/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.lwm2m;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.stream.Stream;

@ApiModel
public class LwM2mResourceObserve {
    @ApiModelProperty(position=1, value="LwM2M Resource Observe id.", example="0")
    int id;
    @ApiModelProperty(position=2, value="LwM2M Resource Observe name.", example="Data")
    String name;
    @ApiModelProperty(position=3, value="LwM2M Resource Observe observe.", example="false")
    boolean observe;
    @ApiModelProperty(position=4, value="LwM2M Resource Observe attribute.", example="false")
    boolean attribute;
    @ApiModelProperty(position=5, value="LwM2M Resource Observe telemetry.", example="false")
    boolean telemetry;
    @ApiModelProperty(position=6, value="LwM2M Resource Observe key name.", example="data")
    String keyName;

    public LwM2mResourceObserve(int id, String name, boolean observe, boolean attribute, boolean telemetry) {
        this.id = id;
        this.name = name;
        this.observe = observe;
        this.attribute = attribute;
        this.telemetry = telemetry;
        this.keyName = this.getCamelCase(this.name);
    }

    private String getCamelCase(String name) {
        name = name.replaceAll("-", " ");
        name = name.replaceAll("_", " ");
        String[] nameCamel1 = name.split(" ");
        CharSequence[] nameCamel2 = new String[nameCamel1.length];
        int[] idx = new int[]{0};
        Stream.of(nameCamel1).forEach(arg_0 -> this.lambda$getCamelCase$0((String[])nameCamel2, idx, arg_0));
        return String.join((CharSequence)"", nameCamel2);
    }

    private String toProperCase(int idx, String s) {
        if (!((String)s).isEmpty() && ((String)s).length() > 0) {
            String s1 = idx == 0 ? ((String)s).substring(0, 1).toLowerCase() : ((String)s).substring(0, 1).toUpperCase();
            String s2 = "";
            if (((String)s).length() > 1) {
                s2 = ((String)s).substring(1).toLowerCase();
            }
            s = s1 + s2;
        }
        return s;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isObserve() {
        return this.observe;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public boolean isTelemetry() {
        return this.telemetry;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setObserve(boolean observe) {
        this.observe = observe;
    }

    public void setAttribute(boolean attribute) {
        this.attribute = attribute;
    }

    public void setTelemetry(boolean telemetry) {
        this.telemetry = telemetry;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2mResourceObserve)) {
            return false;
        }
        LwM2mResourceObserve other = (LwM2mResourceObserve)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isObserve() != other.isObserve()) {
            return false;
        }
        if (this.isAttribute() != other.isAttribute()) {
            return false;
        }
        if (this.isTelemetry() != other.isTelemetry()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$keyName = this.getKeyName();
        String other$keyName = other.getKeyName();
        return !(this$keyName == null ? other$keyName != null : !this$keyName.equals(other$keyName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2mResourceObserve;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + (this.isObserve() ? 79 : 97);
        result = result * 59 + (this.isAttribute() ? 79 : 97);
        result = result * 59 + (this.isTelemetry() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $keyName = this.getKeyName();
        result = result * 59 + ($keyName == null ? 43 : $keyName.hashCode());
        return result;
    }

    public String toString() {
        return "LwM2mResourceObserve(id=" + this.getId() + ", name=" + this.getName() + ", observe=" + this.isObserve() + ", attribute=" + this.isAttribute() + ", telemetry=" + this.isTelemetry() + ", keyName=" + this.getKeyName() + ")";
    }

    @ConstructorProperties(value={"id", "name", "observe", "attribute", "telemetry", "keyName"})
    public LwM2mResourceObserve(int id, String name, boolean observe, boolean attribute, boolean telemetry, String keyName) {
        this.id = id;
        this.name = name;
        this.observe = observe;
        this.attribute = attribute;
        this.telemetry = telemetry;
        this.keyName = keyName;
    }

    private /* synthetic */ void lambda$getCamelCase$0(String[] nameCamel2, int[] idx, String s) {
        int n = idx[0];
        idx[0] = n + 1;
        nameCamel2[idx[0]] = this.toProperCase(n, s);
    }
}

