/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.query.TsValue;

public class ReadTsKvQueryResult {
    private final int queryId;
    private final List<TsKvEntry> data;
    private final long lastEntryTs;

    public TsValue[] toTsValues() {
        if (this.data != null && !this.data.isEmpty()) {
            ArrayList<TsValue> queryValues = new ArrayList<TsValue>();
            for (TsKvEntry v : this.data) {
                queryValues.add(v.toTsValue());
            }
            return queryValues.toArray(new TsValue[queryValues.size()]);
        }
        return new TsValue[0];
    }

    public TsValue toTsValue(ReadTsKvQuery query) {
        if (this.data == null || this.data.isEmpty()) {
            if (Aggregation.SUM.equals((Object)query.getAggregation()) || Aggregation.COUNT.equals((Object)query.getAggregation())) {
                long ts = query.getStartTs() + (query.getEndTs() - query.getStartTs()) / 2L;
                return new TsValue(ts, "0");
            }
            return TsValue.EMPTY;
        }
        if (this.data.size() > 1) {
            throw new RuntimeException("Query Result has multiple data points!");
        }
        return this.data.get(0).toTsValue();
    }

    @ConstructorProperties(value={"queryId", "data", "lastEntryTs"})
    public ReadTsKvQueryResult(int queryId, List<TsKvEntry> data, long lastEntryTs) {
        this.queryId = queryId;
        this.data = data;
        this.lastEntryTs = lastEntryTs;
    }

    public int getQueryId() {
        return this.queryId;
    }

    public List<TsKvEntry> getData() {
        return this.data;
    }

    public long getLastEntryTs() {
        return this.lastEntryTs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadTsKvQueryResult)) {
            return false;
        }
        ReadTsKvQueryResult other = (ReadTsKvQueryResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQueryId() != other.getQueryId()) {
            return false;
        }
        if (this.getLastEntryTs() != other.getLastEntryTs()) {
            return false;
        }
        List<TsKvEntry> this$data = this.getData();
        List<TsKvEntry> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReadTsKvQueryResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQueryId();
        long $lastEntryTs = this.getLastEntryTs();
        result = result * 59 + (int)($lastEntryTs >>> 32 ^ $lastEntryTs);
        List<TsKvEntry> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "ReadTsKvQueryResult(queryId=" + this.getQueryId() + ", data=" + this.getData() + ", lastEntryTs=" + this.getLastEntryTs() + ")";
    }
}

