/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.integration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class Integration
extends AbstractIntegration
implements ExportableEntity<IntegrationId> {
    private static final long serialVersionUID = 4934987577236873728L;
    private ConverterId defaultConverterId;
    private ConverterId downlinkConverterId;
    @NoXss
    @Length(fieldName="routingKey")
    private String routingKey;
    private IntegrationType type;
    @NoXss
    @Length(fieldName="secret")
    private String secret;
    private JsonNode configuration;
    @NoXss
    private JsonNode additionalInfo;
    private IntegrationId externalId;

    public Integration() {
    }

    public Integration(IntegrationId id) {
        super(id);
    }

    public Integration(Integration integration) {
        super(integration);
        this.defaultConverterId = integration.getDefaultConverterId();
        this.downlinkConverterId = integration.getDownlinkConverterId();
        this.routingKey = integration.getRoutingKey();
        this.type = integration.getType();
        this.secret = integration.getSecret();
        this.configuration = integration.getConfiguration();
        this.additionalInfo = integration.getAdditionalInfo();
        this.externalId = integration.getExternalId();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Integration Id. Specify this field to update the Integration. Referencing non-existing Integration Id will cause error. Omit this field to create new Integration.")
    public IntegrationId getId() {
        return super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the integration creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @ApiModelProperty(position=4, value="JSON object with the Uplink Converter Id", required=true)
    public ConverterId getDefaultConverterId() {
        return this.defaultConverterId;
    }

    public void setDefaultConverterId(ConverterId defaultConverterId) {
        this.defaultConverterId = defaultConverterId;
    }

    @ApiModelProperty(position=5, value="JSON object with the Downlink Converter Id")
    public ConverterId getDownlinkConverterId() {
        return this.downlinkConverterId;
    }

    public void setDownlinkConverterId(ConverterId downlinkConverterId) {
        this.downlinkConverterId = downlinkConverterId;
    }

    @ApiModelProperty(position=6, value="String value used by HTTP based integrations for the base URL construction and by the remote integrations. Remote integration uses this value along with the 'secret' for kind of security and validation to be able to connect to the platform using Grpc", required=true, example="ca1a01b6-4ca1-3da5-54e4-a07090b65644")
    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    @ApiModelProperty(position=12, value="String value used by the remote integrations. Remote integration uses this value along with the 'routingKey' for kind of security and validation to be able to connect to the platform using Grpc", example="nl83m1ktpwpwwmww29sm")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    @ApiModelProperty(position=13, value="JSON object representing integration configuration. Each integration type has specific configuration with the connectivity parameters (like 'host' and 'port' for MQTT type or 'baseUrl' for HTTP based type, etc.) and other important parameters dependent on the integration type", required=true)
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @ApiModelProperty(position=14, value="Additional parameters of the integration", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.INTEGRATION;
    }

    public Integration(TenantId tenantId, String name, IntegrationType type, Boolean enabled, Boolean isRemote, Boolean allowCreateDevicesOrAssets, boolean isEdgeTemplate, ConverterId defaultConverterId, ConverterId downlinkConverterId, String routingKey, IntegrationType type1, boolean debugMode, String secret, JsonNode configuration, JsonNode additionalInfo, IntegrationId externalId) {
        super(tenantId, name, type, debugMode, enabled, isRemote, allowCreateDevicesOrAssets, isEdgeTemplate);
        this.defaultConverterId = defaultConverterId;
        this.downlinkConverterId = downlinkConverterId;
        this.routingKey = routingKey;
        this.type = type1;
        this.secret = secret;
        this.configuration = configuration;
        this.additionalInfo = additionalInfo;
        this.externalId = externalId;
    }

    public static IntegrationBuilder builder() {
        return new IntegrationBuilder();
    }

    @Override
    public String toString() {
        return "Integration(super=" + super.toString() + ", defaultConverterId=" + this.getDefaultConverterId() + ", downlinkConverterId=" + this.getDownlinkConverterId() + ", routingKey=" + this.getRoutingKey() + ", type=" + this.type + ", secret=" + this.getSecret() + ", configuration=" + this.getConfiguration() + ", additionalInfo=" + this.getAdditionalInfo() + ", externalId=" + this.getExternalId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Integration)) {
            return false;
        }
        Integration other = (Integration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConverterId this$defaultConverterId = this.getDefaultConverterId();
        ConverterId other$defaultConverterId = other.getDefaultConverterId();
        if (this$defaultConverterId == null ? other$defaultConverterId != null : !((Object)this$defaultConverterId).equals(other$defaultConverterId)) {
            return false;
        }
        ConverterId this$downlinkConverterId = this.getDownlinkConverterId();
        ConverterId other$downlinkConverterId = other.getDownlinkConverterId();
        if (this$downlinkConverterId == null ? other$downlinkConverterId != null : !((Object)this$downlinkConverterId).equals(other$downlinkConverterId)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        IntegrationType this$type = this.type;
        IntegrationType other$type = other.type;
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        JsonNode this$configuration = this.getConfiguration();
        JsonNode other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        JsonNode this$additionalInfo = this.getAdditionalInfo();
        JsonNode other$additionalInfo = other.getAdditionalInfo();
        if (this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo)) {
            return false;
        }
        IntegrationId this$externalId = this.getExternalId();
        IntegrationId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Integration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConverterId $defaultConverterId = this.getDefaultConverterId();
        result = result * 59 + ($defaultConverterId == null ? 43 : ((Object)$defaultConverterId).hashCode());
        ConverterId $downlinkConverterId = this.getDownlinkConverterId();
        result = result * 59 + ($downlinkConverterId == null ? 43 : ((Object)$downlinkConverterId).hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        IntegrationType $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        JsonNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        JsonNode $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
        IntegrationId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    public IntegrationId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(IntegrationId externalId) {
        this.externalId = externalId;
    }

    public static class IntegrationBuilder {
        private TenantId tenantId;
        private String name;
        private IntegrationType type;
        private Boolean enabled;
        private Boolean isRemote;
        private Boolean allowCreateDevicesOrAssets;
        private boolean isEdgeTemplate;
        private ConverterId defaultConverterId;
        private ConverterId downlinkConverterId;
        private String routingKey;
        private IntegrationType type1;
        private boolean debugMode;
        private String secret;
        private JsonNode configuration;
        private JsonNode additionalInfo;
        private IntegrationId externalId;

        IntegrationBuilder() {
        }

        public IntegrationBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public IntegrationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public IntegrationBuilder type(IntegrationType type) {
            this.type = type;
            return this;
        }

        public IntegrationBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public IntegrationBuilder isRemote(Boolean isRemote) {
            this.isRemote = isRemote;
            return this;
        }

        public IntegrationBuilder allowCreateDevicesOrAssets(Boolean allowCreateDevicesOrAssets) {
            this.allowCreateDevicesOrAssets = allowCreateDevicesOrAssets;
            return this;
        }

        public IntegrationBuilder isEdgeTemplate(boolean isEdgeTemplate) {
            this.isEdgeTemplate = isEdgeTemplate;
            return this;
        }

        public IntegrationBuilder defaultConverterId(ConverterId defaultConverterId) {
            this.defaultConverterId = defaultConverterId;
            return this;
        }

        public IntegrationBuilder downlinkConverterId(ConverterId downlinkConverterId) {
            this.downlinkConverterId = downlinkConverterId;
            return this;
        }

        public IntegrationBuilder routingKey(String routingKey) {
            this.routingKey = routingKey;
            return this;
        }

        public IntegrationBuilder type1(IntegrationType type1) {
            this.type1 = type1;
            return this;
        }

        public IntegrationBuilder debugMode(boolean debugMode) {
            this.debugMode = debugMode;
            return this;
        }

        public IntegrationBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public IntegrationBuilder configuration(JsonNode configuration) {
            this.configuration = configuration;
            return this;
        }

        public IntegrationBuilder additionalInfo(JsonNode additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public IntegrationBuilder externalId(IntegrationId externalId) {
            this.externalId = externalId;
            return this;
        }

        public Integration build() {
            return new Integration(this.tenantId, this.name, this.type, this.enabled, this.isRemote, this.allowCreateDevicesOrAssets, this.isEdgeTemplate, this.defaultConverterId, this.downlinkConverterId, this.routingKey, this.type1, this.debugMode, this.secret, this.configuration, this.additionalInfo, this.externalId);
        }

        public String toString() {
            return "Integration.IntegrationBuilder(tenantId=" + this.tenantId + ", name=" + this.name + ", type=" + this.type + ", enabled=" + this.enabled + ", isRemote=" + this.isRemote + ", allowCreateDevicesOrAssets=" + this.allowCreateDevicesOrAssets + ", isEdgeTemplate=" + this.isEdgeTemplate + ", defaultConverterId=" + this.defaultConverterId + ", downlinkConverterId=" + this.downlinkConverterId + ", routingKey=" + this.routingKey + ", type1=" + this.type1 + ", debugMode=" + this.debugMode + ", secret=" + this.secret + ", configuration=" + this.configuration + ", additionalInfo=" + this.additionalInfo + ", externalId=" + this.externalId + ")";
        }
    }
}

