/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.integration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public abstract class AbstractIntegration
extends SearchTextBased<IntegrationId>
implements HasName,
TenantEntity {
    private static final long serialVersionUID = 1934983577296873728L;
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    private IntegrationType type;
    private boolean debugMode;
    private Boolean enabled;
    private Boolean isRemote;
    private Boolean allowCreateDevicesOrAssets;
    private boolean isEdgeTemplate;

    public AbstractIntegration() {
    }

    public AbstractIntegration(IntegrationId id) {
        super(id);
    }

    public AbstractIntegration(AbstractIntegration integration) {
        super(integration);
        this.tenantId = integration.getTenantId();
        this.name = integration.getName();
        this.type = integration.getType();
        this.debugMode = integration.isDebugMode();
        this.enabled = integration.isEnabled();
        this.isRemote = integration.isRemote();
        this.allowCreateDevicesOrAssets = integration.isAllowCreateDevicesOrAssets();
        this.isEdgeTemplate = integration.isEdgeTemplate();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Integration Id. Specify this field to update the Integration. Referencing non-existing Integration Id will cause error. Omit this field to create new Integration.")
    public IntegrationId getId() {
        return (IntegrationId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the integration creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=3, value="JSON object with Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @ApiModelProperty(position=7, required=true, value="The type of the integration")
    public IntegrationType getType() {
        return this.type;
    }

    public void setType(IntegrationType type) {
        this.type = type;
    }

    @ApiModelProperty(position=8, value="Boolean flag to enable/disable saving received messages as debug events")
    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @ApiModelProperty(position=9, value="Boolean flag to enable/disable the integration")
    public Boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(position=10, value="Boolean flag to enable/disable the integration to be executed remotely. Remote integration is launched in a separate microservice. Local integration is executed by the platform core")
    public Boolean isRemote() {
        return this.isRemote != null && this.isRemote != false;
    }

    public void setRemote(Boolean remote) {
        this.isRemote = remote;
    }

    @ApiModelProperty(position=11, value="Boolean flag to allow/disallow the integration to create devices or assets that send message and do not exist in the system yet")
    public Boolean isAllowCreateDevicesOrAssets() {
        return this.allowCreateDevicesOrAssets != null && this.allowCreateDevicesOrAssets != false;
    }

    public void setAllowCreateDevicesOrAssets(Boolean allow) {
        this.allowCreateDevicesOrAssets = allow;
    }

    @Override
    @ApiModelProperty(position=15, required=true, value="Integration Name", example="Http Integration")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=16, value="Boolean flag that specifies that is regular or edge template integration")
    public boolean isEdgeTemplate() {
        return this.isEdgeTemplate;
    }

    public void setEdgeTemplate(boolean edgeTemplate) {
        this.isEdgeTemplate = edgeTemplate;
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Integration [tenantId=");
        builder.append(this.tenantId);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", isRemote=");
        builder.append(this.isRemote);
        builder.append(", allowCreateDevicesOrAssets=");
        builder.append(this.allowCreateDevicesOrAssets);
        builder.append(", isEdgeTemplate=");
        builder.append(this.isEdgeTemplate);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.INTEGRATION;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractIntegration)) {
            return false;
        }
        AbstractIntegration other = (AbstractIntegration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        if (this.isEdgeTemplate() != other.isEdgeTemplate()) {
            return false;
        }
        Boolean this$enabled = this.enabled;
        Boolean other$enabled = other.enabled;
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$isRemote = this.isRemote;
        Boolean other$isRemote = other.isRemote;
        if (this$isRemote == null ? other$isRemote != null : !((Object)this$isRemote).equals(other$isRemote)) {
            return false;
        }
        Boolean this$allowCreateDevicesOrAssets = this.allowCreateDevicesOrAssets;
        Boolean other$allowCreateDevicesOrAssets = other.allowCreateDevicesOrAssets;
        if (this$allowCreateDevicesOrAssets == null ? other$allowCreateDevicesOrAssets != null : !((Object)this$allowCreateDevicesOrAssets).equals(other$allowCreateDevicesOrAssets)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        IntegrationType this$type = this.getType();
        IntegrationType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractIntegration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + (this.isEdgeTemplate() ? 79 : 97);
        Boolean $enabled = this.enabled;
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $isRemote = this.isRemote;
        result = result * 59 + ($isRemote == null ? 43 : ((Object)$isRemote).hashCode());
        Boolean $allowCreateDevicesOrAssets = this.allowCreateDevicesOrAssets;
        result = result * 59 + ($allowCreateDevicesOrAssets == null ? 43 : ((Object)$allowCreateDevicesOrAssets).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        IntegrationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @ConstructorProperties(value={"tenantId", "name", "type", "debugMode", "enabled", "isRemote", "allowCreateDevicesOrAssets", "isEdgeTemplate"})
    public AbstractIntegration(TenantId tenantId, String name, IntegrationType type, boolean debugMode, Boolean enabled, Boolean isRemote, Boolean allowCreateDevicesOrAssets, boolean isEdgeTemplate) {
        this.tenantId = tenantId;
        this.name = name;
        this.type = type;
        this.debugMode = debugMode;
        this.enabled = enabled;
        this.isRemote = isRemote;
        this.allowCreateDevicesOrAssets = allowCreateDevicesOrAssets;
        this.isEdgeTemplate = isEdgeTemplate;
    }
}

