/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.TenantId;

public class RuleChainDebugEvent
extends Event {
    private static final long serialVersionUID = -386392236201116767L;
    private String message;
    private String error;

    private RuleChainDebugEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, String message, String error) {
        super(tenantId, entityId, serviceId, id, ts);
        this.message = message;
        this.error = error;
    }

    @Override
    public EventType getType() {
        return EventType.DEBUG_RULE_CHAIN;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        RuleChainDebugEvent.putNotNull(json, "message", this.message);
        RuleChainDebugEvent.putNotNull(json, "error", this.error);
        return eventInfo;
    }

    public static RuleChainDebugEventBuilder builder() {
        return new RuleChainDebugEventBuilder();
    }

    @Override
    public String toString() {
        return "RuleChainDebugEvent(message=" + this.getMessage() + ", error=" + this.getError() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleChainDebugEvent)) {
            return false;
        }
        RuleChainDebugEvent other = (RuleChainDebugEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RuleChainDebugEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public static class RuleChainDebugEventBuilder {
        private TenantId tenantId;
        private UUID entityId;
        private String serviceId;
        private UUID id;
        private long ts;
        private String message;
        private String error;

        RuleChainDebugEventBuilder() {
        }

        public RuleChainDebugEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RuleChainDebugEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        public RuleChainDebugEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public RuleChainDebugEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public RuleChainDebugEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        public RuleChainDebugEventBuilder message(String message) {
            this.message = message;
            return this;
        }

        public RuleChainDebugEventBuilder error(String error) {
            this.error = error;
            return this;
        }

        public RuleChainDebugEvent build() {
            return new RuleChainDebugEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.message, this.error);
        }

        public String toString() {
            return "RuleChainDebugEvent.RuleChainDebugEventBuilder(tenantId=" + this.tenantId + ", entityId=" + this.entityId + ", serviceId=" + this.serviceId + ", id=" + this.id + ", ts=" + this.ts + ", message=" + this.message + ", error=" + this.error + ")";
        }
    }
}

