/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.TenantId;

public class ErrorEvent
extends Event {
    private static final long serialVersionUID = 960461434033192571L;
    private String method;
    private String error;

    private ErrorEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, String method, String error) {
        super(tenantId, entityId, serviceId, id, ts);
        this.method = method;
        this.error = error;
    }

    @Override
    public EventType getType() {
        return EventType.ERROR;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        json.put("method", this.method);
        if (this.error != null) {
            json.put("error", this.error);
        }
        return eventInfo;
    }

    public static ErrorEventBuilder builder() {
        return new ErrorEventBuilder();
    }

    @Override
    public String toString() {
        return "ErrorEvent(method=" + this.getMethod() + ", error=" + this.getError() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorEvent)) {
            return false;
        }
        ErrorEvent other = (ErrorEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ErrorEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public static class ErrorEventBuilder {
        private TenantId tenantId;
        private UUID entityId;
        private String serviceId;
        private UUID id;
        private long ts;
        private String method;
        private String error;

        ErrorEventBuilder() {
        }

        public ErrorEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ErrorEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        public ErrorEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public ErrorEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public ErrorEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        public ErrorEventBuilder method(String method) {
            this.method = method;
            return this;
        }

        public ErrorEventBuilder error(String error) {
            this.error = error;
            return this;
        }

        public ErrorEvent build() {
            return new ErrorEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.method, this.error);
        }

        public String toString() {
            return "ErrorEvent.ErrorEventBuilder(tenantId=" + this.tenantId + ", entityId=" + this.entityId + ", serviceId=" + this.serviceId + ", id=" + this.id + ", ts=" + this.ts + ", method=" + this.method + ", error=" + this.error + ")";
        }
    }
}

