/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.TenantId;

public class ConverterDebugEvent
extends Event {
    private final String eventType;
    private final String inMsgType;
    private String inMsg;
    private final String outMsgType;
    private String outMsg;
    private String metadata;
    private String error;

    public ConverterDebugEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, String eventType, String inMsgType, String inMsg, String outMsgType, String outMsg, String metadata, String error) {
        super(tenantId, entityId, serviceId, id, ts);
        this.eventType = eventType;
        this.inMsgType = inMsgType;
        this.inMsg = inMsg;
        this.outMsgType = outMsgType;
        this.outMsg = outMsg;
        this.metadata = metadata;
        this.error = error;
    }

    @Override
    public EventType getType() {
        return EventType.DEBUG_CONVERTER;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        json.put("type", this.eventType);
        ConverterDebugEvent.putNotNull(json, "inMessageType", this.inMsgType);
        ConverterDebugEvent.putNotNull(json, "in", this.inMsg);
        ConverterDebugEvent.putNotNull(json, "outMessageType", this.outMsgType);
        ConverterDebugEvent.putNotNull(json, "out", this.outMsg);
        ConverterDebugEvent.putNotNull(json, "metadata", this.metadata);
        ConverterDebugEvent.putNotNull(json, "error", this.error);
        return eventInfo;
    }

    public static ConverterDebugEventBuilder builder() {
        return new ConverterDebugEventBuilder();
    }

    @Override
    public String toString() {
        return "ConverterDebugEvent(eventType=" + this.getEventType() + ", inMsgType=" + this.getInMsgType() + ", inMsg=" + this.getInMsg() + ", outMsgType=" + this.getOutMsgType() + ", outMsg=" + this.getOutMsg() + ", metadata=" + this.getMetadata() + ", error=" + this.getError() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConverterDebugEvent)) {
            return false;
        }
        ConverterDebugEvent other = (ConverterDebugEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$inMsgType = this.getInMsgType();
        String other$inMsgType = other.getInMsgType();
        if (this$inMsgType == null ? other$inMsgType != null : !this$inMsgType.equals(other$inMsgType)) {
            return false;
        }
        String this$inMsg = this.getInMsg();
        String other$inMsg = other.getInMsg();
        if (this$inMsg == null ? other$inMsg != null : !this$inMsg.equals(other$inMsg)) {
            return false;
        }
        String this$outMsgType = this.getOutMsgType();
        String other$outMsgType = other.getOutMsgType();
        if (this$outMsgType == null ? other$outMsgType != null : !this$outMsgType.equals(other$outMsgType)) {
            return false;
        }
        String this$outMsg = this.getOutMsg();
        String other$outMsg = other.getOutMsg();
        if (this$outMsg == null ? other$outMsg != null : !this$outMsg.equals(other$outMsg)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConverterDebugEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $inMsgType = this.getInMsgType();
        result = result * 59 + ($inMsgType == null ? 43 : $inMsgType.hashCode());
        String $inMsg = this.getInMsg();
        result = result * 59 + ($inMsg == null ? 43 : $inMsg.hashCode());
        String $outMsgType = this.getOutMsgType();
        result = result * 59 + ($outMsgType == null ? 43 : $outMsgType.hashCode());
        String $outMsg = this.getOutMsg();
        result = result * 59 + ($outMsg == null ? 43 : $outMsg.hashCode());
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getInMsgType() {
        return this.inMsgType;
    }

    public String getInMsg() {
        return this.inMsg;
    }

    public void setInMsg(String inMsg) {
        this.inMsg = inMsg;
    }

    public String getOutMsgType() {
        return this.outMsgType;
    }

    public String getOutMsg() {
        return this.outMsg;
    }

    public void setOutMsg(String outMsg) {
        this.outMsg = outMsg;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public static class ConverterDebugEventBuilder {
        private TenantId tenantId;
        private UUID entityId;
        private String serviceId;
        private UUID id;
        private long ts;
        private String eventType;
        private String inMsgType;
        private String inMsg;
        private String outMsgType;
        private String outMsg;
        private String metadata;
        private String error;

        ConverterDebugEventBuilder() {
        }

        public ConverterDebugEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ConverterDebugEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        public ConverterDebugEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public ConverterDebugEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public ConverterDebugEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        public ConverterDebugEventBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public ConverterDebugEventBuilder inMsgType(String inMsgType) {
            this.inMsgType = inMsgType;
            return this;
        }

        public ConverterDebugEventBuilder inMsg(String inMsg) {
            this.inMsg = inMsg;
            return this;
        }

        public ConverterDebugEventBuilder outMsgType(String outMsgType) {
            this.outMsgType = outMsgType;
            return this;
        }

        public ConverterDebugEventBuilder outMsg(String outMsg) {
            this.outMsg = outMsg;
            return this;
        }

        public ConverterDebugEventBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public ConverterDebugEventBuilder error(String error) {
            this.error = error;
            return this;
        }

        public ConverterDebugEvent build() {
            return new ConverterDebugEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.eventType, this.inMsgType, this.inMsg, this.outMsgType, this.outMsg, this.metadata, this.error);
        }

        public String toString() {
            return "ConverterDebugEvent.ConverterDebugEventBuilder(tenantId=" + this.tenantId + ", entityId=" + this.entityId + ", serviceId=" + this.serviceId + ", id=" + this.id + ", ts=" + this.ts + ", eventType=" + this.eventType + ", inMsgType=" + this.inMsgType + ", inMsg=" + this.inMsg + ", outMsgType=" + this.outMsgType + ", outMsg=" + this.outMsg + ", metadata=" + this.metadata + ", error=" + this.error + ")";
        }
    }
}

