/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edge;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasLabel;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class Edge
extends SearchTextBasedWithAdditionalInfo<EdgeId>
implements HasLabel,
GroupEntity<EdgeId> {
    private static final long serialVersionUID = 4934987555236873728L;
    private TenantId tenantId;
    private CustomerId customerId;
    private RuleChainId rootRuleChainId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    @NoXss
    @Length(fieldName="type")
    private String type;
    @NoXss
    @Length(fieldName="label")
    private String label;
    @NoXss
    @Length(fieldName="routingKey")
    private String routingKey;
    @NoXss
    @Length(fieldName="secret")
    private String secret;
    @NoXss
    @Length(fieldName="edgeLicenseKey", max=30)
    private String edgeLicenseKey;
    @NoXss
    @Length(fieldName="cloudEndpoint")
    private String cloudEndpoint;

    public Edge() {
    }

    public Edge(EdgeId id) {
        super(id);
    }

    public Edge(Edge edge) {
        super(edge);
        this.tenantId = edge.getTenantId();
        this.customerId = edge.getCustomerId();
        this.type = edge.getType();
        this.name = edge.getName();
        this.routingKey = edge.getRoutingKey();
        this.secret = edge.getSecret();
        this.edgeLicenseKey = edge.getEdgeLicenseKey();
        this.cloudEndpoint = edge.getCloudEndpoint();
        this.rootRuleChainId = edge.getRootRuleChainId();
    }

    public void update(Edge edge) {
        this.tenantId = edge.getTenantId();
        this.customerId = edge.getCustomerId();
        this.rootRuleChainId = edge.getRootRuleChainId();
        this.type = edge.getType();
        this.label = edge.getLabel();
        this.name = edge.getName();
        this.routingKey = edge.getRoutingKey();
        this.secret = edge.getSecret();
        this.edgeLicenseKey = edge.getEdgeLicenseKey();
        this.cloudEndpoint = edge.getCloudEndpoint();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Edge Id. Specify this field to update the Edge. Referencing non-existing Edge Id will cause error. Omit this field to create new Edge.")
    public EdgeId getId() {
        return (EdgeId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the edge creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=3, value="JSON object with Tenant Id. Use 'assignDeviceToTenant' to change the Tenant Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @ApiModelProperty(position=4, value="JSON object with Customer Id. Use 'assignEdgeToCustomer' to change the Customer Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @ApiModelProperty(position=5, value="JSON object with Root Rule Chain Id. Use 'setEdgeRootRuleChain' to change the Root Rule Chain Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public RuleChainId getRootRuleChainId() {
        return this.rootRuleChainId;
    }

    @Override
    @ApiModelProperty(position=6, required=true, value="Unique Edge Name in scope of Tenant", example="Silo_A_Edge")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(position=7, required=true, value="Edge type", example="Silos")
    public String getType() {
        return this.type;
    }

    @Override
    @ApiModelProperty(position=8, value="Label that may be used in widgets", example="Silo Edge on far field")
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @ApiModelProperty(position=9, required=true, value="Edge routing key ('username') to authorize on cloud")
    public String getRoutingKey() {
        return this.routingKey;
    }

    @ApiModelProperty(position=10, required=true, value="Edge secret ('password') to authorize on cloud")
    public String getSecret() {
        return this.secret;
    }

    @ApiModelProperty(position=11, required=true, value="Edge license key obtained from license portal", example="AgcnI24Z06XC&m6Sxsdgf")
    public String getEdgeLicenseKey() {
        return this.edgeLicenseKey;
    }

    @ApiModelProperty(position=12, required=true, value="Edge uses this cloud URL to activate and periodically check it's license", example="https://thingsboard.cloud")
    public String getCloudEndpoint() {
        return this.cloudEndpoint;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.EDGE;
    }

    @Override
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        RuleChainId this$rootRuleChainId = this.getRootRuleChainId();
        RuleChainId other$rootRuleChainId = other.getRootRuleChainId();
        if (this$rootRuleChainId == null ? other$rootRuleChainId != null : !((Object)this$rootRuleChainId).equals(other$rootRuleChainId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$edgeLicenseKey = this.getEdgeLicenseKey();
        String other$edgeLicenseKey = other.getEdgeLicenseKey();
        if (this$edgeLicenseKey == null ? other$edgeLicenseKey != null : !this$edgeLicenseKey.equals(other$edgeLicenseKey)) {
            return false;
        }
        String this$cloudEndpoint = this.getCloudEndpoint();
        String other$cloudEndpoint = other.getCloudEndpoint();
        return !(this$cloudEndpoint == null ? other$cloudEndpoint != null : !this$cloudEndpoint.equals(other$cloudEndpoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Edge;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        RuleChainId $rootRuleChainId = this.getRootRuleChainId();
        result = result * 59 + ($rootRuleChainId == null ? 43 : ((Object)$rootRuleChainId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $edgeLicenseKey = this.getEdgeLicenseKey();
        result = result * 59 + ($edgeLicenseKey == null ? 43 : $edgeLicenseKey.hashCode());
        String $cloudEndpoint = this.getCloudEndpoint();
        result = result * 59 + ($cloudEndpoint == null ? 43 : $cloudEndpoint.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Edge(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", rootRuleChainId=" + this.getRootRuleChainId() + ", name=" + this.getName() + ", type=" + this.getType() + ", label=" + this.getLabel() + ", routingKey=" + this.getRoutingKey() + ", secret=" + this.getSecret() + ", edgeLicenseKey=" + this.getEdgeLicenseKey() + ", cloudEndpoint=" + this.getCloudEndpoint() + ")";
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setRootRuleChainId(RuleChainId rootRuleChainId) {
        this.rootRuleChainId = rootRuleChainId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setEdgeLicenseKey(String edgeLicenseKey) {
        this.edgeLicenseKey = edgeLicenseKey;
    }

    public void setCloudEndpoint(String cloudEndpoint) {
        this.cloudEndpoint = cloudEndpoint;
    }
}

