/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.profile;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import java.util.TreeMap;
import javax.validation.Valid;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.device.profile.AlarmRule;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class DeviceProfileAlarm
implements Serializable {
    @ApiModelProperty(position=1, value="String value representing the alarm rule id", example="highTemperatureAlarmID")
    private String id;
    @Length(fieldName="alarm type")
    @NoXss
    @ApiModelProperty(position=2, value="String value representing type of the alarm", example="High Temperature Alarm")
    private String alarmType;
    @Valid
    @ApiModelProperty(position=3, value="Complex JSON object representing create alarm rules. The unique create alarm rule can be created for each alarm severity type. There can be 5 create alarm rules configured per a single alarm type. See method implementation notes and AlarmRule model for more details")
    private TreeMap<AlarmSeverity, AlarmRule> createRules;
    @Valid
    @ApiModelProperty(position=4, value="JSON object representing clear alarm rule")
    private AlarmRule clearRule;
    @ApiModelProperty(position=5, value="Propagation flag to specify if alarm should be propagated to parent entities of alarm originator", example="true")
    private boolean propagate;
    @ApiModelProperty(position=6, value="Propagation flag to specify if alarm should be propagated to the owner (tenant or customer) of alarm originator", example="true")
    private boolean propagateToOwner;
    @ApiModelProperty(position=7, value="Propagation flag to specify if alarm should be propagated to the owner (tenant or customer) and all parent owners in the customer hierarchy", example="true")
    private boolean propagateToOwnerHierarchy;
    @ApiModelProperty(position=8, value="Propagation flag to specify if alarm should be propagated to the tenant entity", example="true")
    private boolean propagateToTenant;
    @ApiModelProperty(position=9, value="JSON array of relation types that should be used for propagation. By default, 'propagateRelationTypes' array is empty which means that the alarm will be propagated based on any relation type to parent entities. This parameter should be used only in case when 'propagate' parameter is set to true, otherwise, 'propagateRelationTypes' array will be ignored.")
    private List<String> propagateRelationTypes;

    public String getId() {
        return this.id;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public TreeMap<AlarmSeverity, AlarmRule> getCreateRules() {
        return this.createRules;
    }

    public AlarmRule getClearRule() {
        return this.clearRule;
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    public boolean isPropagateToOwner() {
        return this.propagateToOwner;
    }

    public boolean isPropagateToOwnerHierarchy() {
        return this.propagateToOwnerHierarchy;
    }

    public boolean isPropagateToTenant() {
        return this.propagateToTenant;
    }

    public List<String> getPropagateRelationTypes() {
        return this.propagateRelationTypes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    public void setCreateRules(TreeMap<AlarmSeverity, AlarmRule> createRules) {
        this.createRules = createRules;
    }

    public void setClearRule(AlarmRule clearRule) {
        this.clearRule = clearRule;
    }

    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    public void setPropagateToOwner(boolean propagateToOwner) {
        this.propagateToOwner = propagateToOwner;
    }

    public void setPropagateToOwnerHierarchy(boolean propagateToOwnerHierarchy) {
        this.propagateToOwnerHierarchy = propagateToOwnerHierarchy;
    }

    public void setPropagateToTenant(boolean propagateToTenant) {
        this.propagateToTenant = propagateToTenant;
    }

    public void setPropagateRelationTypes(List<String> propagateRelationTypes) {
        this.propagateRelationTypes = propagateRelationTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceProfileAlarm)) {
            return false;
        }
        DeviceProfileAlarm other = (DeviceProfileAlarm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPropagate() != other.isPropagate()) {
            return false;
        }
        if (this.isPropagateToOwner() != other.isPropagateToOwner()) {
            return false;
        }
        if (this.isPropagateToOwnerHierarchy() != other.isPropagateToOwnerHierarchy()) {
            return false;
        }
        if (this.isPropagateToTenant() != other.isPropagateToTenant()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$alarmType = this.getAlarmType();
        String other$alarmType = other.getAlarmType();
        if (this$alarmType == null ? other$alarmType != null : !this$alarmType.equals(other$alarmType)) {
            return false;
        }
        TreeMap<AlarmSeverity, AlarmRule> this$createRules = this.getCreateRules();
        TreeMap<AlarmSeverity, AlarmRule> other$createRules = other.getCreateRules();
        if (this$createRules == null ? other$createRules != null : !((Object)this$createRules).equals(other$createRules)) {
            return false;
        }
        AlarmRule this$clearRule = this.getClearRule();
        AlarmRule other$clearRule = other.getClearRule();
        if (this$clearRule == null ? other$clearRule != null : !((Object)this$clearRule).equals(other$clearRule)) {
            return false;
        }
        List<String> this$propagateRelationTypes = this.getPropagateRelationTypes();
        List<String> other$propagateRelationTypes = other.getPropagateRelationTypes();
        return !(this$propagateRelationTypes == null ? other$propagateRelationTypes != null : !((Object)this$propagateRelationTypes).equals(other$propagateRelationTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceProfileAlarm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPropagate() ? 79 : 97);
        result = result * 59 + (this.isPropagateToOwner() ? 79 : 97);
        result = result * 59 + (this.isPropagateToOwnerHierarchy() ? 79 : 97);
        result = result * 59 + (this.isPropagateToTenant() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $alarmType = this.getAlarmType();
        result = result * 59 + ($alarmType == null ? 43 : $alarmType.hashCode());
        TreeMap<AlarmSeverity, AlarmRule> $createRules = this.getCreateRules();
        result = result * 59 + ($createRules == null ? 43 : ((Object)$createRules).hashCode());
        AlarmRule $clearRule = this.getClearRule();
        result = result * 59 + ($clearRule == null ? 43 : ((Object)$clearRule).hashCode());
        List<String> $propagateRelationTypes = this.getPropagateRelationTypes();
        result = result * 59 + ($propagateRelationTypes == null ? 43 : ((Object)$propagateRelationTypes).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceProfileAlarm(id=" + this.getId() + ", alarmType=" + this.getAlarmType() + ", createRules=" + this.getCreateRules() + ", clearRule=" + this.getClearRule() + ", propagate=" + this.isPropagate() + ", propagateToOwner=" + this.isPropagateToOwner() + ", propagateToOwnerHierarchy=" + this.isPropagateToOwnerHierarchy() + ", propagateToTenant=" + this.isPropagateToTenant() + ", propagateRelationTypes=" + this.getPropagateRelationTypes() + ")";
    }
}

