/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.converter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.converter.ConverterType;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class Converter
extends SearchTextBased<ConverterId>
implements HasName,
TenantEntity,
ExportableEntity<ConverterId> {
    private static final long serialVersionUID = -1541581333235769915L;
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    private ConverterType type;
    private boolean debugMode;
    private JsonNode configuration;
    @NoXss
    private JsonNode additionalInfo;
    private boolean edgeTemplate;
    private ConverterId externalId;

    public Converter() {
    }

    public Converter(ConverterId id) {
        super(id);
    }

    public Converter(Converter converter) {
        super(converter);
        this.tenantId = converter.getTenantId();
        this.name = converter.getName();
        this.type = converter.getType();
        this.debugMode = converter.isDebugMode();
        this.configuration = converter.getConfiguration();
        this.additionalInfo = converter.getAdditionalInfo();
        this.externalId = converter.getExternalId();
        this.edgeTemplate = converter.isEdgeTemplate();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Converter Id. Specify this field to update the Converter. Referencing non-existing Converter Id will cause error. Omit this field to create new Converter.")
    public ConverterId getId() {
        return (ConverterId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the converter creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=3, value="JSON object with Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @ApiModelProperty(position=4, required=true, value="Unique Converter Name in scope of Tenant", example="Http Converter")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=5, required=true, value="The type of the converter to process incoming or outgoing messages")
    public ConverterType getType() {
        return this.type;
    }

    public void setType(ConverterType type) {
        this.type = type;
    }

    @ApiModelProperty(position=6, value="Boolean flag to enable/disable saving received messages as debug events")
    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @ApiModelProperty(position=7, value="JSON object representing converter configuration. It should contain one of two possible fields: 'decoder' or 'encoder'. The former is used when the converter has UPLINK type, the latter is used - when DOWNLINK type. It can contain both 'decoder' and 'encoder' fields, when the correct one is specified for the appropriate converter type, another one can be set to 'null'")
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @ApiModelProperty(position=8, value="Additional parameters of the converter", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @ApiModelProperty(position=9, value="Boolean flag that specifies that is regular or edge template converter")
    public boolean isEdgeTemplate() {
        return this.edgeTemplate;
    }

    public void setEdgeTemplate(boolean edgeTemplate) {
        this.edgeTemplate = edgeTemplate;
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Converter [tenantId=");
        builder.append(this.tenantId);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", debugMode=");
        builder.append(this.debugMode);
        builder.append(", configuration=");
        builder.append(this.configuration);
        builder.append(", additionalInfo=");
        builder.append(this.additionalInfo);
        builder.append(", edgeTemplate=");
        builder.append(this.edgeTemplate);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.CONVERTER;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Converter)) {
            return false;
        }
        Converter other = (Converter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        if (this.isEdgeTemplate() != other.isEdgeTemplate()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ConverterType this$type = this.getType();
        ConverterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        JsonNode this$configuration = this.getConfiguration();
        JsonNode other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        JsonNode this$additionalInfo = this.getAdditionalInfo();
        JsonNode other$additionalInfo = other.getAdditionalInfo();
        if (this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo)) {
            return false;
        }
        ConverterId this$externalId = this.getExternalId();
        ConverterId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Converter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + (this.isEdgeTemplate() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ConverterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        JsonNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        JsonNode $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
        ConverterId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    public ConverterId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(ConverterId externalId) {
        this.externalId = externalId;
    }
}

