/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.blob;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;

public class BlobEntityInfo
extends SearchTextBasedWithAdditionalInfo<BlobEntityId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId {
    private static final long serialVersionUID = 2807223040519549363L;
    @ApiModelProperty(position=3, value="JSON object with Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @ApiModelProperty(position=4, value="JSON object with Customer Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @Length(fieldName="name")
    @ApiModelProperty(position=6, value="blob entity name", accessMode=ApiModelProperty.AccessMode.READ_ONLY, example="report-2021-10-29_14:00:00.pdf")
    private String name;
    @Length(fieldName="type")
    @ApiModelProperty(position=7, value="blob entity type", accessMode=ApiModelProperty.AccessMode.READ_ONLY, example="report")
    private String type;
    @Length(fieldName="contentType")
    @ApiModelProperty(position=8, value="blob content type", accessMode=ApiModelProperty.AccessMode.READ_ONLY, example="application/pdf", allowableValues="application/pdf, image/jpeg, image/png")
    private String contentType;

    public BlobEntityInfo() {
    }

    public BlobEntityInfo(BlobEntityId id) {
        super(id);
    }

    public BlobEntityInfo(BlobEntityInfo blobEntityInfo) {
        super(blobEntityInfo);
        this.tenantId = blobEntityInfo.getTenantId();
        this.customerId = blobEntityInfo.getCustomerId();
        this.name = blobEntityInfo.getName();
        this.type = blobEntityInfo.getType();
        this.contentType = blobEntityInfo.getContentType();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the blob entity Id. Referencing non-existing blob entity Id will cause error")
    public BlobEntityId getId() {
        return (BlobEntityId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the blob entity creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @ApiModelProperty(position=9, value="Additional parameters of the blob entity", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.BLOB_ENTITY;
    }

    @Override
    @ApiModelProperty(position=5, value="JSON object with Customer or Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String toString() {
        return "BlobEntityInfo(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", name=" + this.getName() + ", type=" + this.getType() + ", contentType=" + this.getContentType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlobEntityInfo)) {
            return false;
        }
        BlobEntityInfo other = (BlobEntityInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlobEntityInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }
}

