/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.audit;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.audit.ActionStatus;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.AuditLogId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class AuditLog
extends BaseData<AuditLogId> {
    @ApiModelProperty(position=3, value="JSON object with Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @ApiModelProperty(position=4, value="JSON object with Customer Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private CustomerId customerId;
    @ApiModelProperty(position=5, value="JSON object with Entity id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private EntityId entityId;
    @NoXss
    @ApiModelProperty(position=6, value="Name of the logged entity", example="Thermometer", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String entityName;
    @ApiModelProperty(position=7, value="JSON object with User id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private UserId userId;
    @ApiModelProperty(position=8, value="Unique user name(email) of the user that performed some action on logged entity", example="tenant@thingsboard.org", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String userName;
    @ApiModelProperty(position=9, value="String represented Action type", example="ADDED", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private ActionType actionType;
    @ApiModelProperty(position=10, value="JsonNode represented action data", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private JsonNode actionData;
    @ApiModelProperty(position=11, value="String represented Action status", example="SUCCESS", allowableValues="SUCCESS,FAILURE", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private ActionStatus actionStatus;
    @ApiModelProperty(position=12, value="Failure action details info. An empty string in case of action status type 'SUCCESS', otherwise includes stack trace of the caused exception.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String actionFailureDetails;

    public AuditLog() {
    }

    public AuditLog(AuditLogId id) {
        super(id);
    }

    public AuditLog(AuditLog auditLog) {
        super(auditLog);
        this.tenantId = auditLog.getTenantId();
        this.customerId = auditLog.getCustomerId();
        this.entityId = auditLog.getEntityId();
        this.entityName = auditLog.getEntityName();
        this.userId = auditLog.getUserId();
        this.userName = auditLog.getUserName();
        this.actionType = auditLog.getActionType();
        this.actionData = auditLog.getActionData();
        this.actionStatus = auditLog.getActionStatus();
        this.actionFailureDetails = auditLog.getActionFailureDetails();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the auditLog creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the auditLog Id")
    public AuditLogId getId() {
        return (AuditLogId)super.getId();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditLog)) {
            return false;
        }
        AuditLog other = (AuditLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        JsonNode this$actionData = this.getActionData();
        JsonNode other$actionData = other.getActionData();
        if (this$actionData == null ? other$actionData != null : !this$actionData.equals(other$actionData)) {
            return false;
        }
        ActionStatus this$actionStatus = this.getActionStatus();
        ActionStatus other$actionStatus = other.getActionStatus();
        if (this$actionStatus == null ? other$actionStatus != null : !((Object)((Object)this$actionStatus)).equals((Object)other$actionStatus)) {
            return false;
        }
        String this$actionFailureDetails = this.getActionFailureDetails();
        String other$actionFailureDetails = other.getActionFailureDetails();
        return !(this$actionFailureDetails == null ? other$actionFailureDetails != null : !this$actionFailureDetails.equals(other$actionFailureDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditLog;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        JsonNode $actionData = this.getActionData();
        result = result * 59 + ($actionData == null ? 43 : $actionData.hashCode());
        ActionStatus $actionStatus = this.getActionStatus();
        result = result * 59 + ($actionStatus == null ? 43 : ((Object)((Object)$actionStatus)).hashCode());
        String $actionFailureDetails = this.getActionFailureDetails();
        result = result * 59 + ($actionFailureDetails == null ? 43 : $actionFailureDetails.hashCode());
        return result;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public UserId getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public JsonNode getActionData() {
        return this.actionData;
    }

    public ActionStatus getActionStatus() {
        return this.actionStatus;
    }

    public String getActionFailureDetails() {
        return this.actionFailureDetails;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public void setActionData(JsonNode actionData) {
        this.actionData = actionData;
    }

    public void setActionStatus(ActionStatus actionStatus) {
        this.actionStatus = actionStatus;
    }

    public void setActionFailureDetails(String actionFailureDetails) {
        this.actionFailureDetails = actionFailureDetails;
    }

    @Override
    public String toString() {
        return "AuditLog(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", entityId=" + this.getEntityId() + ", entityName=" + this.getEntityName() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", actionType=" + this.getActionType() + ", actionData=" + this.getActionData() + ", actionStatus=" + this.getActionStatus() + ", actionFailureDetails=" + this.getActionFailureDetails() + ")";
    }
}

