/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmAssignee;

@ApiModel
public class AlarmInfo
extends Alarm {
    private static final long serialVersionUID = 2807343093519543363L;
    @ApiModelProperty(position=20, value="Alarm originator name", example="Thermostat")
    private String originatorName;
    @ApiModelProperty(position=21, value="Alarm originator label", example="Thermostat label")
    private String originatorLabel;
    @ApiModelProperty(position=22, value="Alarm assignee")
    private AlarmAssignee assignee;

    public AlarmInfo() {
    }

    public AlarmInfo(Alarm alarm) {
        super(alarm);
    }

    public AlarmInfo(AlarmInfo alarmInfo) {
        super(alarmInfo);
        this.originatorName = alarmInfo.originatorName;
        this.originatorLabel = alarmInfo.originatorLabel;
        this.assignee = alarmInfo.getAssignee();
    }

    public AlarmInfo(Alarm alarm, String originatorName, String originatorLabel, AlarmAssignee assignee) {
        super(alarm);
        this.originatorName = originatorName;
        this.originatorLabel = originatorLabel;
        this.assignee = assignee;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmInfo)) {
            return false;
        }
        AlarmInfo other = (AlarmInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$originatorName = this.getOriginatorName();
        String other$originatorName = other.getOriginatorName();
        if (this$originatorName == null ? other$originatorName != null : !this$originatorName.equals(other$originatorName)) {
            return false;
        }
        String this$originatorLabel = this.getOriginatorLabel();
        String other$originatorLabel = other.getOriginatorLabel();
        if (this$originatorLabel == null ? other$originatorLabel != null : !this$originatorLabel.equals(other$originatorLabel)) {
            return false;
        }
        AlarmAssignee this$assignee = this.getAssignee();
        AlarmAssignee other$assignee = other.getAssignee();
        return !(this$assignee == null ? other$assignee != null : !((Object)this$assignee).equals(other$assignee));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AlarmInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $originatorName = this.getOriginatorName();
        result = result * 59 + ($originatorName == null ? 43 : $originatorName.hashCode());
        String $originatorLabel = this.getOriginatorLabel();
        result = result * 59 + ($originatorLabel == null ? 43 : $originatorLabel.hashCode());
        AlarmAssignee $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : ((Object)$assignee).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AlarmInfo(super=" + super.toString() + ", originatorName=" + this.getOriginatorName() + ", originatorLabel=" + this.getOriginatorLabel() + ", assignee=" + this.getAssignee() + ")";
    }

    public String getOriginatorName() {
        return this.originatorName;
    }

    public void setOriginatorName(String originatorName) {
        this.originatorName = originatorName;
    }

    public String getOriginatorLabel() {
        return this.originatorLabel;
    }

    public void setOriginatorLabel(String originatorLabel) {
        this.originatorLabel = originatorLabel;
    }

    public AlarmAssignee getAssignee() {
        return this.assignee;
    }

    public void setAssignee(AlarmAssignee assignee) {
        this.assignee = assignee;
    }
}

