/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import java.io.Serializable;
import java.util.List;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.EntityId;

public class AlarmApiCallResult
implements Serializable {
    private final boolean successful;
    private final boolean created;
    private final boolean modified;
    private final boolean cleared;
    private final boolean deleted;
    private final AlarmInfo alarm;
    private final Alarm old;
    private final List<EntityId> propagatedEntitiesList;

    private AlarmApiCallResult(boolean successful, boolean created, boolean modified, boolean cleared, boolean deleted, AlarmInfo alarm, Alarm old, List<EntityId> propagatedEntitiesList) {
        this.successful = successful;
        this.created = created;
        this.modified = modified;
        this.cleared = cleared;
        this.deleted = deleted;
        this.alarm = alarm;
        this.old = old;
        this.propagatedEntitiesList = propagatedEntitiesList;
    }

    public AlarmApiCallResult(AlarmApiCallResult other, List<EntityId> propagatedEntitiesList) {
        this.successful = other.successful;
        this.created = other.created;
        this.modified = other.modified;
        this.cleared = other.cleared;
        this.deleted = other.deleted;
        this.alarm = other.alarm;
        this.old = other.old;
        this.propagatedEntitiesList = propagatedEntitiesList;
    }

    public boolean isSeverityChanged() {
        if (this.alarm == null || this.old == null) {
            return false;
        }
        return !this.alarm.getSeverity().equals((Object)this.old.getSeverity());
    }

    public boolean isAcknowledged() {
        if (this.alarm == null || this.old == null) {
            return false;
        }
        return this.alarm.isAcknowledged() != this.old.isAcknowledged();
    }

    public AlarmSeverity getOldSeverity() {
        return this.isSeverityChanged() ? this.old.getSeverity() : null;
    }

    public boolean isPropagationChanged() {
        if (this.created) {
            return true;
        }
        if (this.alarm == null || this.old == null) {
            return false;
        }
        return this.alarm.isPropagate() != this.old.isPropagate() || this.alarm.isPropagateToOwner() != this.old.isPropagateToOwner() || this.alarm.isPropagateToTenant() != this.old.isPropagateToTenant() || !this.alarm.getPropagateRelationTypes().equals(this.old.getPropagateRelationTypes());
    }

    public static AlarmApiCallResultBuilder builder() {
        return new AlarmApiCallResultBuilder();
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public AlarmInfo getAlarm() {
        return this.alarm;
    }

    public Alarm getOld() {
        return this.old;
    }

    public List<EntityId> getPropagatedEntitiesList() {
        return this.propagatedEntitiesList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmApiCallResult)) {
            return false;
        }
        AlarmApiCallResult other = (AlarmApiCallResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        if (this.isCreated() != other.isCreated()) {
            return false;
        }
        if (this.isModified() != other.isModified()) {
            return false;
        }
        if (this.isCleared() != other.isCleared()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        AlarmInfo this$alarm = this.getAlarm();
        AlarmInfo other$alarm = other.getAlarm();
        if (this$alarm == null ? other$alarm != null : !((Object)this$alarm).equals(other$alarm)) {
            return false;
        }
        Alarm this$old = this.getOld();
        Alarm other$old = other.getOld();
        if (this$old == null ? other$old != null : !((Object)this$old).equals(other$old)) {
            return false;
        }
        List<EntityId> this$propagatedEntitiesList = this.getPropagatedEntitiesList();
        List<EntityId> other$propagatedEntitiesList = other.getPropagatedEntitiesList();
        return !(this$propagatedEntitiesList == null ? other$propagatedEntitiesList != null : !((Object)this$propagatedEntitiesList).equals(other$propagatedEntitiesList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmApiCallResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        result = result * 59 + (this.isCreated() ? 79 : 97);
        result = result * 59 + (this.isModified() ? 79 : 97);
        result = result * 59 + (this.isCleared() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        AlarmInfo $alarm = this.getAlarm();
        result = result * 59 + ($alarm == null ? 43 : ((Object)$alarm).hashCode());
        Alarm $old = this.getOld();
        result = result * 59 + ($old == null ? 43 : ((Object)$old).hashCode());
        List<EntityId> $propagatedEntitiesList = this.getPropagatedEntitiesList();
        result = result * 59 + ($propagatedEntitiesList == null ? 43 : ((Object)$propagatedEntitiesList).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmApiCallResult(successful=" + this.isSuccessful() + ", created=" + this.isCreated() + ", modified=" + this.isModified() + ", cleared=" + this.isCleared() + ", deleted=" + this.isDeleted() + ", alarm=" + this.getAlarm() + ", old=" + this.getOld() + ", propagatedEntitiesList=" + this.getPropagatedEntitiesList() + ")";
    }

    public static class AlarmApiCallResultBuilder {
        private boolean successful;
        private boolean created;
        private boolean modified;
        private boolean cleared;
        private boolean deleted;
        private AlarmInfo alarm;
        private Alarm old;
        private List<EntityId> propagatedEntitiesList;

        AlarmApiCallResultBuilder() {
        }

        public AlarmApiCallResultBuilder successful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public AlarmApiCallResultBuilder created(boolean created) {
            this.created = created;
            return this;
        }

        public AlarmApiCallResultBuilder modified(boolean modified) {
            this.modified = modified;
            return this;
        }

        public AlarmApiCallResultBuilder cleared(boolean cleared) {
            this.cleared = cleared;
            return this;
        }

        public AlarmApiCallResultBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public AlarmApiCallResultBuilder alarm(AlarmInfo alarm) {
            this.alarm = alarm;
            return this;
        }

        public AlarmApiCallResultBuilder old(Alarm old) {
            this.old = old;
            return this;
        }

        public AlarmApiCallResultBuilder propagatedEntitiesList(List<EntityId> propagatedEntitiesList) {
            this.propagatedEntitiesList = propagatedEntitiesList;
            return this;
        }

        public AlarmApiCallResult build() {
            return new AlarmApiCallResult(this.successful, this.created, this.modified, this.cleared, this.deleted, this.alarm, this.old, this.propagatedEntitiesList);
        }

        public String toString() {
            return "AlarmApiCallResult.AlarmApiCallResultBuilder(successful=" + this.successful + ", created=" + this.created + ", modified=" + this.modified + ", cleared=" + this.cleared + ", deleted=" + this.deleted + ", alarm=" + this.alarm + ", old=" + this.old + ", propagatedEntitiesList=" + this.propagatedEntitiesList + ")";
        }
    }
}

