/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.group.EntityField;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;

@ApiModel
public class ShortEntityView
implements HasId<EntityId>,
HasName {
    @ApiModelProperty(position=1, value="Entity Id object", required=true, accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private EntityId id;
    @ApiModelProperty(position=2, value="Map of entity fields that is configurable in the Entity Group", required=true, accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private Map<String, String> properties = new HashMap<String, String>();
    @JsonIgnore
    private boolean skipEntity = false;

    public ShortEntityView(EntityId id) {
        this.id = id;
    }

    @Override
    public EntityId getId() {
        return this.id;
    }

    @JsonAnyGetter
    public Map<String, String> properties() {
        return this.properties;
    }

    @JsonAnySetter
    public void put(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    @ApiModelProperty(position=3, value="Name of the entity", required=true, accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.properties.get(EntityField.NAME.name().toLowerCase());
    }

    public boolean isSkipEntity() {
        return this.skipEntity;
    }

    public void setSkipEntity(boolean skipEntity) {
        this.skipEntity = skipEntity;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShortEntityView that = (ShortEntityView)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public ShortEntityView() {
    }
}

