/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.EntityId;

public class EntityFieldsData {
    private static final ObjectMapper mapper = new ObjectMapper();
    private ObjectNode fieldsData;

    public EntityFieldsData(BaseData data) {
        this.fieldsData = (ObjectNode)mapper.valueToTree((Object)data);
    }

    public String getFieldValue(String field) {
        return this.getFieldValue(field, false);
    }

    public String getFieldValue(String field, boolean ignoreNullStrings) {
        String[] fieldsTree = field.split("\\.");
        ObjectNode current = this.fieldsData;
        for (String key : fieldsTree) {
            if (!current.has(key)) {
                current = null;
                break;
            }
            current = current.get(key);
        }
        if (current != null) {
            if (current.isNull() && ignoreNullStrings) {
                return null;
            }
            if (current.isValueNode()) {
                return current.asText();
            }
            try {
                return mapper.writeValueAsString((Object)current);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }
        return null;
    }

    public ObjectNode getFieldsData() {
        return this.fieldsData;
    }

    public void setFieldsData(ObjectNode fieldsData) {
        this.fieldsData = fieldsData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityFieldsData)) {
            return false;
        }
        EntityFieldsData other = (EntityFieldsData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectNode this$fieldsData = this.getFieldsData();
        ObjectNode other$fieldsData = other.getFieldsData();
        return !(this$fieldsData == null ? other$fieldsData != null : !this$fieldsData.equals(other$fieldsData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityFieldsData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectNode $fieldsData = this.getFieldsData();
        result = result * 59 + ($fieldsData == null ? 43 : $fieldsData.hashCode());
        return result;
    }

    public String toString() {
        return "EntityFieldsData(fieldsData=" + this.getFieldsData() + ")";
    }

    @ConstructorProperties(value={"fieldsData"})
    public EntityFieldsData(ObjectNode fieldsData) {
        this.fieldsData = fieldsData;
    }

    static {
        SimpleModule entityFieldsModule = new SimpleModule("EntityFieldsModule", new Version(1, 0, 0, null, null, null));
        entityFieldsModule.addSerializer(EntityId.class, (JsonSerializer)new EntityIdFieldSerializer());
        mapper.disable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS});
        mapper.registerModule((Module)entityFieldsModule);
    }

    private static class EntityIdFieldSerializer
    extends JsonSerializer<EntityId> {
        private EntityIdFieldSerializer() {
        }

        public void serialize(EntityId value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeObject((Object)value.getId());
        }
    }
}

