/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Throwables;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public final class EdgeUtils {
    private static final Logger log = LoggerFactory.getLogger(EdgeUtils.class);
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("(\\$\\{\\{)(.*?)(}})");
    private static final String ATTRIBUTE_PLACEHOLDER_PATTERN = "${{%s}}";
    private static final String ATTRIBUTE_REGEXP_PLACEHOLDER_PATTERN = "\\$\\{\\{%s}}";
    private static final int STACK_TRACE_LIMIT = 10;

    private EdgeUtils() {
    }

    public static EdgeEventType getEdgeEventTypeByEntityType(EntityType entityType) {
        switch (entityType) {
            case EDGE: {
                return EdgeEventType.EDGE;
            }
            case DEVICE: {
                return EdgeEventType.DEVICE;
            }
            case DEVICE_PROFILE: {
                return EdgeEventType.DEVICE_PROFILE;
            }
            case ASSET: {
                return EdgeEventType.ASSET;
            }
            case ASSET_PROFILE: {
                return EdgeEventType.ASSET_PROFILE;
            }
            case ENTITY_VIEW: {
                return EdgeEventType.ENTITY_VIEW;
            }
            case DASHBOARD: {
                return EdgeEventType.DASHBOARD;
            }
            case USER: {
                return EdgeEventType.USER;
            }
            case RULE_CHAIN: {
                return EdgeEventType.RULE_CHAIN;
            }
            case ALARM: {
                return EdgeEventType.ALARM;
            }
            case TENANT: {
                return EdgeEventType.TENANT;
            }
            case CUSTOMER: {
                return EdgeEventType.CUSTOMER;
            }
            case WIDGETS_BUNDLE: {
                return EdgeEventType.WIDGETS_BUNDLE;
            }
            case WIDGET_TYPE: {
                return EdgeEventType.WIDGET_TYPE;
            }
            case OTA_PACKAGE: {
                return EdgeEventType.OTA_PACKAGE;
            }
            case QUEUE: {
                return EdgeEventType.QUEUE;
            }
            case ENTITY_GROUP: {
                return EdgeEventType.ENTITY_GROUP;
            }
            case SCHEDULER_EVENT: {
                return EdgeEventType.SCHEDULER_EVENT;
            }
            case ROLE: {
                return EdgeEventType.ROLE;
            }
            case GROUP_PERMISSION: {
                return EdgeEventType.GROUP_PERMISSION;
            }
            case INTEGRATION: {
                return EdgeEventType.INTEGRATION;
            }
            case CONVERTER: {
                return EdgeEventType.CONVERTER;
            }
        }
        log.warn("Unsupported entity type [{}]", (Object)entityType);
        return null;
    }

    public static int nextPositiveInt() {
        return ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
    }

    public static EdgeEvent constructEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body) {
        return EdgeUtils.constructEdgeEvent(tenantId, edgeId, type, action, entityId, body, null);
    }

    public static EdgeEvent constructEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body, EntityId entityGroupId) {
        EdgeEvent edgeEvent = new EdgeEvent();
        edgeEvent.setTenantId(tenantId);
        edgeEvent.setEdgeId(edgeId);
        edgeEvent.setType(type);
        edgeEvent.setAction(action);
        if (entityId != null) {
            edgeEvent.setEntityId(entityId.getId());
        }
        if (entityGroupId != null) {
            edgeEvent.setEntityGroupId(entityGroupId.getId());
        }
        edgeEvent.setBody(body);
        return edgeEvent;
    }

    public static Set<String> getAttributeKeysFromConfiguration(String integrationConfiguration) {
        HashSet<String> result = new HashSet<String>();
        Matcher m = ATTRIBUTE_PATTERN.matcher(integrationConfiguration);
        while (m.find()) {
            result.add(m.group(2));
        }
        return result;
    }

    public static String formatAttributeKeyToPlaceholderFormat(String attributeKey) {
        return String.format(ATTRIBUTE_PLACEHOLDER_PATTERN, attributeKey);
    }

    public static String formatAttributeKeyToRegexpPlaceholderFormat(String attributeKey) {
        return String.format(ATTRIBUTE_REGEXP_PLACEHOLDER_PATTERN, attributeKey);
    }

    public static String createErrorMsgFromRootCauseAndStackTrace(Throwable t) {
        Throwable rootCause = Throwables.getRootCause((Throwable)t);
        StringBuilder errorMsg = new StringBuilder(rootCause.getMessage() != null ? rootCause.getMessage() : "");
        if (rootCause.getStackTrace().length > 0) {
            int idx = 0;
            for (StackTraceElement stackTraceElement : rootCause.getStackTrace()) {
                errorMsg.append("\n").append(stackTraceElement.toString());
                if (++idx > 10) break;
            }
        }
        return errorMsg.toString();
    }

    public static boolean isEdgeGroupAll(String groupName) {
        if (groupName == null) {
            return false;
        }
        return groupName.startsWith("[Edge]") && groupName.endsWith("All");
    }
}

