/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.ShortCustomerInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class Customer
extends ContactBased<CustomerId>
implements HasTenantId,
HasTitle,
GroupEntity<CustomerId>,
ExportableEntity<CustomerId> {
    private static final long serialVersionUID = -1599722990298929275L;
    @NoXss
    @Length(fieldName="title")
    @ApiModelProperty(position=3, value="Title of the customer", example="Company A")
    private String title;
    @ApiModelProperty(position=5, required=true, value="JSON object with Tenant Id")
    private TenantId tenantId;
    @ApiModelProperty(position=6, value="JSON object with parent Customer Id")
    private CustomerId parentCustomerId;
    private CustomerId externalId;

    public Customer() {
    }

    public Customer(CustomerId id) {
        super(id);
    }

    public Customer(Customer customer) {
        super(customer);
        this.tenantId = customer.getTenantId();
        this.parentCustomerId = customer.getParentCustomerId();
        this.title = customer.getTitle();
        this.externalId = customer.getExternalId();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public CustomerId getParentCustomerId() {
        return this.parentCustomerId;
    }

    public void setParentCustomerId(CustomerId parentCustomerId) {
        this.parentCustomerId = parentCustomerId;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @ApiModelProperty(position=7, accessMode=ApiModelProperty.AccessMode.READ_ONLY, value="JSON object with parent Customer Id")
    public CustomerId getCustomerId() {
        return this.parentCustomerId;
    }

    @Override
    @ApiModelProperty(position=8, value="JSON object with Customer or Tenant Id", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.parentCustomerId != null && !this.parentCustomerId.isNullUid() ? this.parentCustomerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.parentCustomerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @JsonIgnore
    public boolean isSubCustomer() {
        return this.parentCustomerId != null && !this.parentCustomerId.isNullUid();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the customer Id. Specify this field to update the customer. Referencing non-existing customer Id will cause error. Omit this field to create new customer.")
    public CustomerId getId() {
        return (CustomerId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the customer creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=9, required=true, value="Country", example="US")
    public String getCountry() {
        return super.getCountry();
    }

    @Override
    @ApiModelProperty(position=10, required=true, value="State", example="NY")
    public String getState() {
        return super.getState();
    }

    @Override
    @ApiModelProperty(position=11, required=true, value="City", example="New York")
    public String getCity() {
        return super.getCity();
    }

    @Override
    @ApiModelProperty(position=12, required=true, value="Address Line 1", example="42 Broadway Suite 12-400")
    public String getAddress() {
        return super.getAddress();
    }

    @Override
    @ApiModelProperty(position=13, required=true, value="Address Line 2", example="")
    public String getAddress2() {
        return super.getAddress2();
    }

    @Override
    @ApiModelProperty(position=14, required=true, value="Zip code", example="10004")
    public String getZip() {
        return super.getZip();
    }

    @Override
    @ApiModelProperty(position=15, required=true, value="Phone number", example="+1(415)777-7777")
    public String getPhone() {
        return super.getPhone();
    }

    @Override
    @ApiModelProperty(position=16, required=true, value="Email", example="example@company.com")
    public String getEmail() {
        return super.getEmail();
    }

    @Override
    @ApiModelProperty(position=17, value="Additional parameters of the device", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @JsonIgnore
    public boolean isPublic() {
        if (this.getAdditionalInfo() != null && this.getAdditionalInfo().has("isPublic")) {
            return this.getAdditionalInfo().get("isPublic").asBoolean();
        }
        return false;
    }

    @JsonIgnore
    public ShortCustomerInfo toShortCustomerInfo() {
        return new ShortCustomerInfo((CustomerId)this.id, this.title, this.isPublic());
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @ApiModelProperty(position=4, value="Name of the customer. Read-only, duplicated from title for backward compatibility", example="Company A", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    public String getSearchText() {
        return this.getTitle();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Customer [title=");
        builder.append(this.title);
        builder.append(", tenantId=");
        builder.append(this.tenantId);
        builder.append(", additionalInfo=");
        builder.append(this.getAdditionalInfo());
        builder.append(", country=");
        builder.append(this.country);
        builder.append(", state=");
        builder.append(this.state);
        builder.append(", city=");
        builder.append(this.city);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", address2=");
        builder.append(this.address2);
        builder.append(", zip=");
        builder.append(this.zip);
        builder.append(", phone=");
        builder.append(this.phone);
        builder.append(", email=");
        builder.append(this.email);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.CUSTOMER;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$parentCustomerId = this.getParentCustomerId();
        CustomerId other$parentCustomerId = other.getParentCustomerId();
        if (this$parentCustomerId == null ? other$parentCustomerId != null : !((Object)this$parentCustomerId).equals(other$parentCustomerId)) {
            return false;
        }
        CustomerId this$externalId = this.getExternalId();
        CustomerId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Customer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $parentCustomerId = this.getParentCustomerId();
        result = result * 59 + ($parentCustomerId == null ? 43 : ((Object)$parentCustomerId).hashCode());
        CustomerId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    public CustomerId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(CustomerId externalId) {
        this.externalId = externalId;
    }
}

