/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.sync.vc;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.thingsboard.server.common.data.sync.vc.EntityLoadError;
import org.thingsboard.server.common.data.sync.vc.EntityTypeLoadResult;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VersionLoadResult
implements Serializable {
    private static final long serialVersionUID = -1386093599856747449L;
    private List<EntityTypeLoadResult> result;
    private EntityLoadError error;
    private boolean done;

    public static VersionLoadResult empty() {
        return VersionLoadResult.builder().result(Collections.emptyList()).build();
    }

    public static VersionLoadResult success(List<EntityTypeLoadResult> result) {
        return VersionLoadResult.builder().result(result).build();
    }

    public static VersionLoadResult success(EntityTypeLoadResult result) {
        return VersionLoadResult.builder().result(List.of(result)).build();
    }

    public static VersionLoadResult error(EntityLoadError error) {
        return VersionLoadResult.builder().error(error).done(true).build();
    }

    @ConstructorProperties(value={"result", "error", "done"})
    VersionLoadResult(List<EntityTypeLoadResult> result, EntityLoadError error, boolean done) {
        this.result = result;
        this.error = error;
        this.done = done;
    }

    public static VersionLoadResultBuilder builder() {
        return new VersionLoadResultBuilder();
    }

    public List<EntityTypeLoadResult> getResult() {
        return this.result;
    }

    public EntityLoadError getError() {
        return this.error;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setResult(List<EntityTypeLoadResult> result) {
        this.result = result;
    }

    public void setError(EntityLoadError error) {
        this.error = error;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionLoadResult)) {
            return false;
        }
        VersionLoadResult other = (VersionLoadResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDone() != other.isDone()) {
            return false;
        }
        List<EntityTypeLoadResult> this$result = this.getResult();
        List<EntityTypeLoadResult> other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        EntityLoadError this$error = this.getError();
        EntityLoadError other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionLoadResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDone() ? 79 : 97);
        List<EntityTypeLoadResult> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        EntityLoadError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public String toString() {
        return "VersionLoadResult(result=" + this.getResult() + ", error=" + this.getError() + ", done=" + this.isDone() + ")";
    }

    public static class VersionLoadResultBuilder {
        private List<EntityTypeLoadResult> result;
        private EntityLoadError error;
        private boolean done;

        VersionLoadResultBuilder() {
        }

        public VersionLoadResultBuilder result(List<EntityTypeLoadResult> result) {
            this.result = result;
            return this;
        }

        public VersionLoadResultBuilder error(EntityLoadError error) {
            this.error = error;
            return this;
        }

        public VersionLoadResultBuilder done(boolean done) {
            this.done = done;
            return this;
        }

        public VersionLoadResult build() {
            return new VersionLoadResult(this.result, this.error, this.done);
        }

        public String toString() {
            return "VersionLoadResult.VersionLoadResultBuilder(result=" + this.result + ", error=" + this.error + ", done=" + this.done + ")";
        }
    }
}

