/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rpc;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rpc.RpcStatus;

@ApiModel
public class Rpc
extends BaseData<RpcId>
implements HasTenantId {
    @ApiModelProperty(position=3, value="JSON object with Tenant Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @ApiModelProperty(position=4, value="JSON object with Device Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private DeviceId deviceId;
    @ApiModelProperty(position=5, value="Expiration time of the request.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private long expirationTime;
    @ApiModelProperty(position=6, value="The request body that will be used to send message to device.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private JsonNode request;
    @ApiModelProperty(position=7, value="The response from the device.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private JsonNode response;
    @ApiModelProperty(position=8, value="The current status of the RPC call.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private RpcStatus status;
    @ApiModelProperty(position=9, value="Additional info used in the rule engine to process the updates to the RPC state.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private JsonNode additionalInfo;

    public Rpc() {
    }

    public Rpc(RpcId id) {
        super(id);
    }

    public Rpc(Rpc rpc) {
        super(rpc);
        this.tenantId = rpc.getTenantId();
        this.deviceId = rpc.getDeviceId();
        this.expirationTime = rpc.getExpirationTime();
        this.request = rpc.getRequest();
        this.response = rpc.getResponse();
        this.status = rpc.getStatus();
        this.additionalInfo = rpc.getAdditionalInfo();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the rpc Id. Referencing non-existing rpc Id will cause error.")
    public RpcId getId() {
        return (RpcId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the rpc creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public JsonNode getRequest() {
        return this.request;
    }

    public JsonNode getResponse() {
        return this.response;
    }

    public RpcStatus getStatus() {
        return this.status;
    }

    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setDeviceId(DeviceId deviceId) {
        this.deviceId = deviceId;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setRequest(JsonNode request) {
        this.request = request;
    }

    public void setResponse(JsonNode response) {
        this.response = response;
    }

    public void setStatus(RpcStatus status) {
        this.status = status;
    }

    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Override
    public String toString() {
        return "Rpc(tenantId=" + this.getTenantId() + ", deviceId=" + this.getDeviceId() + ", expirationTime=" + this.getExpirationTime() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", status=" + this.getStatus() + ", additionalInfo=" + this.getAdditionalInfo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rpc)) {
            return false;
        }
        Rpc other = (Rpc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getExpirationTime() != other.getExpirationTime()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !((Object)this$deviceId).equals(other$deviceId)) {
            return false;
        }
        JsonNode this$request = this.getRequest();
        JsonNode other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        JsonNode this$response = this.getResponse();
        JsonNode other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        RpcStatus this$status = this.getStatus();
        RpcStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        JsonNode this$additionalInfo = this.getAdditionalInfo();
        JsonNode other$additionalInfo = other.getAdditionalInfo();
        return !(this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rpc;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $expirationTime = this.getExpirationTime();
        result = result * 59 + (int)($expirationTime >>> 32 ^ $expirationTime);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : ((Object)$deviceId).hashCode());
        JsonNode $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        JsonNode $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        RpcStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        JsonNode $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
        return result;
    }
}

