/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.relation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;

@ApiModel
public class RelationsSearchParameters {
    @ApiModelProperty(position=1, value="Root entity id to start search from.", example="784f394c-42b6-435a-983c-b7beff2784f9")
    private UUID rootId;
    @ApiModelProperty(position=2, value="Type of the root entity.")
    private EntityType rootType;
    @ApiModelProperty(position=3, value="Type of the root entity.")
    private EntitySearchDirection direction;
    @ApiModelProperty(position=4, value="Type of the relation.")
    private RelationTypeGroup relationTypeGroup;
    @ApiModelProperty(position=5, value="Maximum level of the search depth.")
    private int maxLevel = 1;
    @ApiModelProperty(position=6, value="Fetch entities that match the last level of search. Useful to find Devices that are strictly 'maxLevel' relations away from the root entity.")
    private boolean fetchLastLevelOnly;

    public RelationsSearchParameters(EntityId entityId, EntitySearchDirection direction, int maxLevel, boolean fetchLastLevelOnly) {
        this(entityId, direction, maxLevel, RelationTypeGroup.COMMON, fetchLastLevelOnly);
    }

    public RelationsSearchParameters(EntityId entityId, EntitySearchDirection direction, int maxLevel, RelationTypeGroup relationTypeGroup, boolean fetchLastLevelOnly) {
        this.rootId = entityId.getId();
        this.rootType = entityId.getEntityType();
        this.direction = direction;
        this.maxLevel = maxLevel;
        this.relationTypeGroup = relationTypeGroup;
        this.fetchLastLevelOnly = fetchLastLevelOnly;
    }

    @JsonIgnore
    public EntityId getEntityId() {
        return EntityIdFactory.getByTypeAndUuid(this.rootType, this.rootId);
    }

    public UUID getRootId() {
        return this.rootId;
    }

    public EntityType getRootType() {
        return this.rootType;
    }

    public EntitySearchDirection getDirection() {
        return this.direction;
    }

    public RelationTypeGroup getRelationTypeGroup() {
        return this.relationTypeGroup;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean isFetchLastLevelOnly() {
        return this.fetchLastLevelOnly;
    }

    public void setRootId(UUID rootId) {
        this.rootId = rootId;
    }

    public void setRootType(EntityType rootType) {
        this.rootType = rootType;
    }

    public void setDirection(EntitySearchDirection direction) {
        this.direction = direction;
    }

    public void setRelationTypeGroup(RelationTypeGroup relationTypeGroup) {
        this.relationTypeGroup = relationTypeGroup;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public void setFetchLastLevelOnly(boolean fetchLastLevelOnly) {
        this.fetchLastLevelOnly = fetchLastLevelOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationsSearchParameters)) {
            return false;
        }
        RelationsSearchParameters other = (RelationsSearchParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        if (this.isFetchLastLevelOnly() != other.isFetchLastLevelOnly()) {
            return false;
        }
        UUID this$rootId = this.getRootId();
        UUID other$rootId = other.getRootId();
        if (this$rootId == null ? other$rootId != null : !((Object)this$rootId).equals(other$rootId)) {
            return false;
        }
        EntityType this$rootType = this.getRootType();
        EntityType other$rootType = other.getRootType();
        if (this$rootType == null ? other$rootType != null : !((Object)((Object)this$rootType)).equals((Object)other$rootType)) {
            return false;
        }
        EntitySearchDirection this$direction = this.getDirection();
        EntitySearchDirection other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        RelationTypeGroup this$relationTypeGroup = this.getRelationTypeGroup();
        RelationTypeGroup other$relationTypeGroup = other.getRelationTypeGroup();
        return !(this$relationTypeGroup == null ? other$relationTypeGroup != null : !((Object)((Object)this$relationTypeGroup)).equals((Object)other$relationTypeGroup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelationsSearchParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLevel();
        result = result * 59 + (this.isFetchLastLevelOnly() ? 79 : 97);
        UUID $rootId = this.getRootId();
        result = result * 59 + ($rootId == null ? 43 : ((Object)$rootId).hashCode());
        EntityType $rootType = this.getRootType();
        result = result * 59 + ($rootType == null ? 43 : ((Object)((Object)$rootType)).hashCode());
        EntitySearchDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        RelationTypeGroup $relationTypeGroup = this.getRelationTypeGroup();
        result = result * 59 + ($relationTypeGroup == null ? 43 : ((Object)((Object)$relationTypeGroup)).hashCode());
        return result;
    }

    public String toString() {
        return "RelationsSearchParameters(rootId=" + this.getRootId() + ", rootType=" + this.getRootType() + ", direction=" + this.getDirection() + ", relationTypeGroup=" + this.getRelationTypeGroup() + ", maxLevel=" + this.getMaxLevel() + ", fetchLastLevelOnly=" + this.isFetchLastLevelOnly() + ")";
    }

    @ConstructorProperties(value={"rootId", "rootType", "direction", "relationTypeGroup", "maxLevel", "fetchLastLevelOnly"})
    public RelationsSearchParameters(UUID rootId, EntityType rootType, EntitySearchDirection direction, RelationTypeGroup relationTypeGroup, int maxLevel, boolean fetchLastLevelOnly) {
        this.rootId = rootId;
        this.rootType = rootType;
        this.direction = direction;
        this.relationTypeGroup = relationTypeGroup;
        this.maxLevel = maxLevel;
        this.fetchLastLevelOnly = fetchLastLevelOnly;
    }
}

