/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.query.ComparisonTsValue;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.TsValue;

public class EntityData {
    private final EntityId entityId;
    private final Map<EntityKeyType, Map<String, TsValue>> latest;
    private final Map<String, TsValue[]> timeseries;
    private final Map<Integer, ComparisonTsValue> aggLatest;

    public EntityData(EntityId entityId, Map<EntityKeyType, Map<String, TsValue>> latest, Map<String, TsValue[]> timeseries) {
        this(entityId, latest, timeseries, null);
    }

    @JsonIgnore
    public void clearTsAndAggData() {
        if (this.timeseries != null) {
            this.timeseries.clear();
        }
        if (this.aggLatest != null) {
            this.aggLatest.clear();
        }
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public Map<EntityKeyType, Map<String, TsValue>> getLatest() {
        return this.latest;
    }

    public Map<String, TsValue[]> getTimeseries() {
        return this.timeseries;
    }

    public Map<Integer, ComparisonTsValue> getAggLatest() {
        return this.aggLatest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityData)) {
            return false;
        }
        EntityData other = (EntityData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        Map<EntityKeyType, Map<String, TsValue>> this$latest = this.getLatest();
        Map<EntityKeyType, Map<String, TsValue>> other$latest = other.getLatest();
        if (this$latest == null ? other$latest != null : !((Object)this$latest).equals(other$latest)) {
            return false;
        }
        Map<String, TsValue[]> this$timeseries = this.getTimeseries();
        Map<String, TsValue[]> other$timeseries = other.getTimeseries();
        if (this$timeseries == null ? other$timeseries != null : !((Object)this$timeseries).equals(other$timeseries)) {
            return false;
        }
        Map<Integer, ComparisonTsValue> this$aggLatest = this.getAggLatest();
        Map<Integer, ComparisonTsValue> other$aggLatest = other.getAggLatest();
        return !(this$aggLatest == null ? other$aggLatest != null : !((Object)this$aggLatest).equals(other$aggLatest));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        Map<EntityKeyType, Map<String, TsValue>> $latest = this.getLatest();
        result = result * 59 + ($latest == null ? 43 : ((Object)$latest).hashCode());
        Map<String, TsValue[]> $timeseries = this.getTimeseries();
        result = result * 59 + ($timeseries == null ? 43 : ((Object)$timeseries).hashCode());
        Map<Integer, ComparisonTsValue> $aggLatest = this.getAggLatest();
        result = result * 59 + ($aggLatest == null ? 43 : ((Object)$aggLatest).hashCode());
        return result;
    }

    public String toString() {
        return "EntityData(entityId=" + this.getEntityId() + ", latest=" + this.getLatest() + ", timeseries=" + this.getTimeseries() + ", aggLatest=" + this.getAggLatest() + ")";
    }

    @ConstructorProperties(value={"entityId", "latest", "timeseries", "aggLatest"})
    public EntityData(EntityId entityId, Map<EntityKeyType, Map<String, TsValue>> latest, Map<String, TsValue[]> timeseries, Map<Integer, ComparisonTsValue> aggLatest) {
        this.entityId = entityId;
        this.latest = latest;
        this.timeseries = timeseries;
        this.aggLatest = aggLatest;
    }
}

