/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.template;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.template.NotificationTemplateConfig;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class NotificationTemplate
extends BaseData<NotificationTemplateId>
implements HasTenantId,
HasName {
    private TenantId tenantId;
    @NoXss
    @NotEmpty
    @Length(max=255, message="cannot be longer than 255 chars")
    private String name;
    @NoXss
    @NotNull
    private NotificationType notificationType;
    @Valid
    @NotNull
    private NotificationTemplateConfig configuration;

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    public NotificationTemplateConfig getConfiguration() {
        return this.configuration;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNotificationType(NotificationType notificationType) {
        this.notificationType = notificationType;
    }

    public void setConfiguration(NotificationTemplateConfig configuration) {
        this.configuration = configuration;
    }

    @Override
    public String toString() {
        return "NotificationTemplate(tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", notificationType=" + this.getNotificationType() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationTemplate)) {
            return false;
        }
        NotificationTemplate other = (NotificationTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NotificationType this$notificationType = this.getNotificationType();
        NotificationType other$notificationType = other.getNotificationType();
        if (this$notificationType == null ? other$notificationType != null : !((Object)((Object)this$notificationType)).equals((Object)other$notificationType)) {
            return false;
        }
        NotificationTemplateConfig this$configuration = this.getConfiguration();
        NotificationTemplateConfig other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotificationTemplate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NotificationType $notificationType = this.getNotificationType();
        result = result * 59 + ($notificationType == null ? 43 : ((Object)((Object)$notificationType)).hashCode());
        NotificationTemplateConfig $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

