/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.targets;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.targets.NotificationTargetConfig;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class NotificationTarget
extends BaseData<NotificationTargetId>
implements HasTenantId,
HasName {
    private TenantId tenantId;
    @NotBlank
    @NoXss
    @Length(max=255, message="cannot be longer than 255 chars")
    private String name;
    @NotNull
    @Valid
    private NotificationTargetConfig configuration;

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public NotificationTargetConfig getConfiguration() {
        return this.configuration;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConfiguration(NotificationTargetConfig configuration) {
        this.configuration = configuration;
    }

    @Override
    public String toString() {
        return "NotificationTarget(tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationTarget)) {
            return false;
        }
        NotificationTarget other = (NotificationTarget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NotificationTargetConfig this$configuration = this.getConfiguration();
        NotificationTargetConfig other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotificationTarget;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NotificationTargetConfig $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

