/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public class EntityActionNotificationInfo
implements RuleOriginatedNotificationInfo {
    private EntityId entityId;
    private String entityName;
    private ActionType actionType;
    private CustomerId entityCustomerId;
    private UUID userId;
    private String userTitle;
    private String userEmail;
    private String userFirstName;
    private String userLastName;

    @Override
    public Map<String, String> getTemplateData() {
        return CollectionsUtil.mapOf("entityType", this.entityId.getEntityType().getNormalName(), "entityId", this.entityId.toString(), "entityName", this.entityName, "actionType", this.actionType.name().toLowerCase(), "userId", this.userId.toString(), "userTitle", this.userTitle, "userEmail", this.userEmail, "userFirstName", this.userFirstName, "userLastName", this.userLastName);
    }

    @Override
    public CustomerId getAffectedCustomerId() {
        return this.entityCustomerId;
    }

    @Override
    public EntityId getStateEntityId() {
        return this.entityId;
    }

    public static EntityActionNotificationInfoBuilder builder() {
        return new EntityActionNotificationInfoBuilder();
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public CustomerId getEntityCustomerId() {
        return this.entityCustomerId;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public String getUserTitle() {
        return this.userTitle;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public void setEntityCustomerId(CustomerId entityCustomerId) {
        this.entityCustomerId = entityCustomerId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public void setUserTitle(String userTitle) {
        this.userTitle = userTitle;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityActionNotificationInfo)) {
            return false;
        }
        EntityActionNotificationInfo other = (EntityActionNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        CustomerId this$entityCustomerId = this.getEntityCustomerId();
        CustomerId other$entityCustomerId = other.getEntityCustomerId();
        if (this$entityCustomerId == null ? other$entityCustomerId != null : !((Object)this$entityCustomerId).equals(other$entityCustomerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$userTitle = this.getUserTitle();
        String other$userTitle = other.getUserTitle();
        if (this$userTitle == null ? other$userTitle != null : !this$userTitle.equals(other$userTitle)) {
            return false;
        }
        String this$userEmail = this.getUserEmail();
        String other$userEmail = other.getUserEmail();
        if (this$userEmail == null ? other$userEmail != null : !this$userEmail.equals(other$userEmail)) {
            return false;
        }
        String this$userFirstName = this.getUserFirstName();
        String other$userFirstName = other.getUserFirstName();
        if (this$userFirstName == null ? other$userFirstName != null : !this$userFirstName.equals(other$userFirstName)) {
            return false;
        }
        String this$userLastName = this.getUserLastName();
        String other$userLastName = other.getUserLastName();
        return !(this$userLastName == null ? other$userLastName != null : !this$userLastName.equals(other$userLastName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityActionNotificationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        CustomerId $entityCustomerId = this.getEntityCustomerId();
        result = result * 59 + ($entityCustomerId == null ? 43 : ((Object)$entityCustomerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $userTitle = this.getUserTitle();
        result = result * 59 + ($userTitle == null ? 43 : $userTitle.hashCode());
        String $userEmail = this.getUserEmail();
        result = result * 59 + ($userEmail == null ? 43 : $userEmail.hashCode());
        String $userFirstName = this.getUserFirstName();
        result = result * 59 + ($userFirstName == null ? 43 : $userFirstName.hashCode());
        String $userLastName = this.getUserLastName();
        result = result * 59 + ($userLastName == null ? 43 : $userLastName.hashCode());
        return result;
    }

    public String toString() {
        return "EntityActionNotificationInfo(entityId=" + this.getEntityId() + ", entityName=" + this.getEntityName() + ", actionType=" + this.getActionType() + ", entityCustomerId=" + this.getEntityCustomerId() + ", userId=" + this.getUserId() + ", userTitle=" + this.getUserTitle() + ", userEmail=" + this.getUserEmail() + ", userFirstName=" + this.getUserFirstName() + ", userLastName=" + this.getUserLastName() + ")";
    }

    public EntityActionNotificationInfo() {
    }

    @ConstructorProperties(value={"entityId", "entityName", "actionType", "entityCustomerId", "userId", "userTitle", "userEmail", "userFirstName", "userLastName"})
    public EntityActionNotificationInfo(EntityId entityId, String entityName, ActionType actionType, CustomerId entityCustomerId, UUID userId, String userTitle, String userEmail, String userFirstName, String userLastName) {
        this.entityId = entityId;
        this.entityName = entityName;
        this.actionType = actionType;
        this.entityCustomerId = entityCustomerId;
        this.userId = userId;
        this.userTitle = userTitle;
        this.userEmail = userEmail;
        this.userFirstName = userFirstName;
        this.userLastName = userLastName;
    }

    public static class EntityActionNotificationInfoBuilder {
        private EntityId entityId;
        private String entityName;
        private ActionType actionType;
        private CustomerId entityCustomerId;
        private UUID userId;
        private String userTitle;
        private String userEmail;
        private String userFirstName;
        private String userLastName;

        EntityActionNotificationInfoBuilder() {
        }

        public EntityActionNotificationInfoBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        public EntityActionNotificationInfoBuilder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public EntityActionNotificationInfoBuilder actionType(ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public EntityActionNotificationInfoBuilder entityCustomerId(CustomerId entityCustomerId) {
            this.entityCustomerId = entityCustomerId;
            return this;
        }

        public EntityActionNotificationInfoBuilder userId(UUID userId) {
            this.userId = userId;
            return this;
        }

        public EntityActionNotificationInfoBuilder userTitle(String userTitle) {
            this.userTitle = userTitle;
            return this;
        }

        public EntityActionNotificationInfoBuilder userEmail(String userEmail) {
            this.userEmail = userEmail;
            return this;
        }

        public EntityActionNotificationInfoBuilder userFirstName(String userFirstName) {
            this.userFirstName = userFirstName;
            return this;
        }

        public EntityActionNotificationInfoBuilder userLastName(String userLastName) {
            this.userLastName = userLastName;
            return this;
        }

        public EntityActionNotificationInfo build() {
            return new EntityActionNotificationInfo(this.entityId, this.entityName, this.actionType, this.entityCustomerId, this.userId, this.userTitle, this.userEmail, this.userFirstName, this.userLastName);
        }

        public String toString() {
            return "EntityActionNotificationInfo.EntityActionNotificationInfoBuilder(entityId=" + this.entityId + ", entityName=" + this.entityName + ", actionType=" + this.actionType + ", entityCustomerId=" + this.entityCustomerId + ", userId=" + this.userId + ", userTitle=" + this.userTitle + ", userEmail=" + this.userEmail + ", userFirstName=" + this.userFirstName + ", userLastName=" + this.userLastName + ")";
        }
    }
}

