/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.UUID;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.util.CollectionsUtil;

public class AlarmNotificationInfo
implements RuleOriginatedNotificationInfo {
    private String alarmType;
    private String action;
    private UUID alarmId;
    private EntityId alarmOriginator;
    private String alarmOriginatorName;
    private AlarmSeverity alarmSeverity;
    private AlarmStatus alarmStatus;
    private CustomerId alarmCustomerId;

    @Override
    public Map<String, String> getTemplateData() {
        return CollectionsUtil.mapOf("alarmType", this.alarmType, "action", this.action, "alarmId", this.alarmId.toString(), "alarmSeverity", this.alarmSeverity.name().toLowerCase(), "alarmStatus", this.alarmStatus.toString(), "alarmOriginatorEntityType", this.alarmOriginator.getEntityType().getNormalName(), "alarmOriginatorName", this.alarmOriginatorName, "alarmOriginatorId", this.alarmOriginator.getId().toString());
    }

    @Override
    public CustomerId getAffectedCustomerId() {
        return this.alarmCustomerId;
    }

    @Override
    public EntityId getStateEntityId() {
        return this.alarmOriginator;
    }

    public static AlarmNotificationInfoBuilder builder() {
        return new AlarmNotificationInfoBuilder();
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public String getAction() {
        return this.action;
    }

    public UUID getAlarmId() {
        return this.alarmId;
    }

    public EntityId getAlarmOriginator() {
        return this.alarmOriginator;
    }

    public String getAlarmOriginatorName() {
        return this.alarmOriginatorName;
    }

    public AlarmSeverity getAlarmSeverity() {
        return this.alarmSeverity;
    }

    public AlarmStatus getAlarmStatus() {
        return this.alarmStatus;
    }

    public CustomerId getAlarmCustomerId() {
        return this.alarmCustomerId;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setAlarmId(UUID alarmId) {
        this.alarmId = alarmId;
    }

    public void setAlarmOriginator(EntityId alarmOriginator) {
        this.alarmOriginator = alarmOriginator;
    }

    public void setAlarmOriginatorName(String alarmOriginatorName) {
        this.alarmOriginatorName = alarmOriginatorName;
    }

    public void setAlarmSeverity(AlarmSeverity alarmSeverity) {
        this.alarmSeverity = alarmSeverity;
    }

    public void setAlarmStatus(AlarmStatus alarmStatus) {
        this.alarmStatus = alarmStatus;
    }

    public void setAlarmCustomerId(CustomerId alarmCustomerId) {
        this.alarmCustomerId = alarmCustomerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmNotificationInfo)) {
            return false;
        }
        AlarmNotificationInfo other = (AlarmNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alarmType = this.getAlarmType();
        String other$alarmType = other.getAlarmType();
        if (this$alarmType == null ? other$alarmType != null : !this$alarmType.equals(other$alarmType)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        UUID this$alarmId = this.getAlarmId();
        UUID other$alarmId = other.getAlarmId();
        if (this$alarmId == null ? other$alarmId != null : !((Object)this$alarmId).equals(other$alarmId)) {
            return false;
        }
        EntityId this$alarmOriginator = this.getAlarmOriginator();
        EntityId other$alarmOriginator = other.getAlarmOriginator();
        if (this$alarmOriginator == null ? other$alarmOriginator != null : !this$alarmOriginator.equals(other$alarmOriginator)) {
            return false;
        }
        String this$alarmOriginatorName = this.getAlarmOriginatorName();
        String other$alarmOriginatorName = other.getAlarmOriginatorName();
        if (this$alarmOriginatorName == null ? other$alarmOriginatorName != null : !this$alarmOriginatorName.equals(other$alarmOriginatorName)) {
            return false;
        }
        AlarmSeverity this$alarmSeverity = this.getAlarmSeverity();
        AlarmSeverity other$alarmSeverity = other.getAlarmSeverity();
        if (this$alarmSeverity == null ? other$alarmSeverity != null : !((Object)((Object)this$alarmSeverity)).equals((Object)other$alarmSeverity)) {
            return false;
        }
        AlarmStatus this$alarmStatus = this.getAlarmStatus();
        AlarmStatus other$alarmStatus = other.getAlarmStatus();
        if (this$alarmStatus == null ? other$alarmStatus != null : !((Object)((Object)this$alarmStatus)).equals((Object)other$alarmStatus)) {
            return false;
        }
        CustomerId this$alarmCustomerId = this.getAlarmCustomerId();
        CustomerId other$alarmCustomerId = other.getAlarmCustomerId();
        return !(this$alarmCustomerId == null ? other$alarmCustomerId != null : !((Object)this$alarmCustomerId).equals(other$alarmCustomerId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmNotificationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alarmType = this.getAlarmType();
        result = result * 59 + ($alarmType == null ? 43 : $alarmType.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        UUID $alarmId = this.getAlarmId();
        result = result * 59 + ($alarmId == null ? 43 : ((Object)$alarmId).hashCode());
        EntityId $alarmOriginator = this.getAlarmOriginator();
        result = result * 59 + ($alarmOriginator == null ? 43 : $alarmOriginator.hashCode());
        String $alarmOriginatorName = this.getAlarmOriginatorName();
        result = result * 59 + ($alarmOriginatorName == null ? 43 : $alarmOriginatorName.hashCode());
        AlarmSeverity $alarmSeverity = this.getAlarmSeverity();
        result = result * 59 + ($alarmSeverity == null ? 43 : ((Object)((Object)$alarmSeverity)).hashCode());
        AlarmStatus $alarmStatus = this.getAlarmStatus();
        result = result * 59 + ($alarmStatus == null ? 43 : ((Object)((Object)$alarmStatus)).hashCode());
        CustomerId $alarmCustomerId = this.getAlarmCustomerId();
        result = result * 59 + ($alarmCustomerId == null ? 43 : ((Object)$alarmCustomerId).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmNotificationInfo(alarmType=" + this.getAlarmType() + ", action=" + this.getAction() + ", alarmId=" + this.getAlarmId() + ", alarmOriginator=" + this.getAlarmOriginator() + ", alarmOriginatorName=" + this.getAlarmOriginatorName() + ", alarmSeverity=" + this.getAlarmSeverity() + ", alarmStatus=" + this.getAlarmStatus() + ", alarmCustomerId=" + this.getAlarmCustomerId() + ")";
    }

    public AlarmNotificationInfo() {
    }

    @ConstructorProperties(value={"alarmType", "action", "alarmId", "alarmOriginator", "alarmOriginatorName", "alarmSeverity", "alarmStatus", "alarmCustomerId"})
    public AlarmNotificationInfo(String alarmType, String action, UUID alarmId, EntityId alarmOriginator, String alarmOriginatorName, AlarmSeverity alarmSeverity, AlarmStatus alarmStatus, CustomerId alarmCustomerId) {
        this.alarmType = alarmType;
        this.action = action;
        this.alarmId = alarmId;
        this.alarmOriginator = alarmOriginator;
        this.alarmOriginatorName = alarmOriginatorName;
        this.alarmSeverity = alarmSeverity;
        this.alarmStatus = alarmStatus;
        this.alarmCustomerId = alarmCustomerId;
    }

    public static class AlarmNotificationInfoBuilder {
        private String alarmType;
        private String action;
        private UUID alarmId;
        private EntityId alarmOriginator;
        private String alarmOriginatorName;
        private AlarmSeverity alarmSeverity;
        private AlarmStatus alarmStatus;
        private CustomerId alarmCustomerId;

        AlarmNotificationInfoBuilder() {
        }

        public AlarmNotificationInfoBuilder alarmType(String alarmType) {
            this.alarmType = alarmType;
            return this;
        }

        public AlarmNotificationInfoBuilder action(String action) {
            this.action = action;
            return this;
        }

        public AlarmNotificationInfoBuilder alarmId(UUID alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public AlarmNotificationInfoBuilder alarmOriginator(EntityId alarmOriginator) {
            this.alarmOriginator = alarmOriginator;
            return this;
        }

        public AlarmNotificationInfoBuilder alarmOriginatorName(String alarmOriginatorName) {
            this.alarmOriginatorName = alarmOriginatorName;
            return this;
        }

        public AlarmNotificationInfoBuilder alarmSeverity(AlarmSeverity alarmSeverity) {
            this.alarmSeverity = alarmSeverity;
            return this;
        }

        public AlarmNotificationInfoBuilder alarmStatus(AlarmStatus alarmStatus) {
            this.alarmStatus = alarmStatus;
            return this;
        }

        public AlarmNotificationInfoBuilder alarmCustomerId(CustomerId alarmCustomerId) {
            this.alarmCustomerId = alarmCustomerId;
            return this;
        }

        public AlarmNotificationInfo build() {
            return new AlarmNotificationInfo(this.alarmType, this.action, this.alarmId, this.alarmOriginator, this.alarmOriginatorName, this.alarmSeverity, this.alarmStatus, this.alarmCustomerId);
        }

        public String toString() {
            return "AlarmNotificationInfo.AlarmNotificationInfoBuilder(alarmType=" + this.alarmType + ", action=" + this.action + ", alarmId=" + this.alarmId + ", alarmOriginator=" + this.alarmOriginator + ", alarmOriginatorName=" + this.alarmOriginatorName + ", alarmSeverity=" + this.alarmSeverity + ", alarmStatus=" + this.alarmStatus + ", alarmCustomerId=" + this.alarmCustomerId + ")";
        }
    }
}

