/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.device.profile;

import java.util.Objects;
import java.util.Set;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.JsonTransportPayloadConfiguration;
import org.thingsboard.server.common.data.device.profile.TransportPayloadTypeConfiguration;
import org.thingsboard.server.common.data.validation.NoXss;

public class MqttDeviceProfileTransportConfiguration
implements DeviceProfileTransportConfiguration {
    @NoXss
    private String deviceTelemetryTopic = "v1/devices/me/telemetry";
    @NoXss
    private String deviceAttributesTopic = "v1/devices/me/attributes";
    @NoXss
    private String deviceAttributesSubscribeTopic = "v1/devices/me/attributes";
    private TransportPayloadTypeConfiguration transportPayloadTypeConfiguration;
    private boolean sparkplug;
    private Set<String> sparkplugAttributesMetricNames;
    private boolean sendAckOnValidationException;

    @Override
    public DeviceTransportType getType() {
        return DeviceTransportType.MQTT;
    }

    public TransportPayloadTypeConfiguration getTransportPayloadTypeConfiguration() {
        return Objects.requireNonNullElseGet(this.transportPayloadTypeConfiguration, JsonTransportPayloadConfiguration::new);
    }

    public String getDeviceTelemetryTopic() {
        return StringUtils.notBlankOrDefault(this.deviceTelemetryTopic, "v1/devices/me/telemetry");
    }

    public String getDeviceAttributesTopic() {
        return StringUtils.notBlankOrDefault(this.deviceAttributesTopic, "v1/devices/me/attributes");
    }

    public String getDeviceAttributesSubscribeTopic() {
        return StringUtils.notBlankOrDefault(this.deviceAttributesSubscribeTopic, "v1/devices/me/attributes");
    }

    public boolean isSparkplug() {
        return this.sparkplug;
    }

    public Set<String> getSparkplugAttributesMetricNames() {
        return this.sparkplugAttributesMetricNames;
    }

    public boolean isSendAckOnValidationException() {
        return this.sendAckOnValidationException;
    }

    public void setDeviceTelemetryTopic(String deviceTelemetryTopic) {
        this.deviceTelemetryTopic = deviceTelemetryTopic;
    }

    public void setDeviceAttributesTopic(String deviceAttributesTopic) {
        this.deviceAttributesTopic = deviceAttributesTopic;
    }

    public void setDeviceAttributesSubscribeTopic(String deviceAttributesSubscribeTopic) {
        this.deviceAttributesSubscribeTopic = deviceAttributesSubscribeTopic;
    }

    public void setTransportPayloadTypeConfiguration(TransportPayloadTypeConfiguration transportPayloadTypeConfiguration) {
        this.transportPayloadTypeConfiguration = transportPayloadTypeConfiguration;
    }

    public void setSparkplug(boolean sparkplug) {
        this.sparkplug = sparkplug;
    }

    public void setSparkplugAttributesMetricNames(Set<String> sparkplugAttributesMetricNames) {
        this.sparkplugAttributesMetricNames = sparkplugAttributesMetricNames;
    }

    public void setSendAckOnValidationException(boolean sendAckOnValidationException) {
        this.sendAckOnValidationException = sendAckOnValidationException;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttDeviceProfileTransportConfiguration)) {
            return false;
        }
        MqttDeviceProfileTransportConfiguration other = (MqttDeviceProfileTransportConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSparkplug() != other.isSparkplug()) {
            return false;
        }
        if (this.isSendAckOnValidationException() != other.isSendAckOnValidationException()) {
            return false;
        }
        String this$deviceTelemetryTopic = this.getDeviceTelemetryTopic();
        String other$deviceTelemetryTopic = other.getDeviceTelemetryTopic();
        if (this$deviceTelemetryTopic == null ? other$deviceTelemetryTopic != null : !this$deviceTelemetryTopic.equals(other$deviceTelemetryTopic)) {
            return false;
        }
        String this$deviceAttributesTopic = this.getDeviceAttributesTopic();
        String other$deviceAttributesTopic = other.getDeviceAttributesTopic();
        if (this$deviceAttributesTopic == null ? other$deviceAttributesTopic != null : !this$deviceAttributesTopic.equals(other$deviceAttributesTopic)) {
            return false;
        }
        String this$deviceAttributesSubscribeTopic = this.getDeviceAttributesSubscribeTopic();
        String other$deviceAttributesSubscribeTopic = other.getDeviceAttributesSubscribeTopic();
        if (this$deviceAttributesSubscribeTopic == null ? other$deviceAttributesSubscribeTopic != null : !this$deviceAttributesSubscribeTopic.equals(other$deviceAttributesSubscribeTopic)) {
            return false;
        }
        TransportPayloadTypeConfiguration this$transportPayloadTypeConfiguration = this.getTransportPayloadTypeConfiguration();
        TransportPayloadTypeConfiguration other$transportPayloadTypeConfiguration = other.getTransportPayloadTypeConfiguration();
        if (this$transportPayloadTypeConfiguration == null ? other$transportPayloadTypeConfiguration != null : !this$transportPayloadTypeConfiguration.equals(other$transportPayloadTypeConfiguration)) {
            return false;
        }
        Set<String> this$sparkplugAttributesMetricNames = this.getSparkplugAttributesMetricNames();
        Set<String> other$sparkplugAttributesMetricNames = other.getSparkplugAttributesMetricNames();
        return !(this$sparkplugAttributesMetricNames == null ? other$sparkplugAttributesMetricNames != null : !((Object)this$sparkplugAttributesMetricNames).equals(other$sparkplugAttributesMetricNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqttDeviceProfileTransportConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSparkplug() ? 79 : 97);
        result = result * 59 + (this.isSendAckOnValidationException() ? 79 : 97);
        String $deviceTelemetryTopic = this.getDeviceTelemetryTopic();
        result = result * 59 + ($deviceTelemetryTopic == null ? 43 : $deviceTelemetryTopic.hashCode());
        String $deviceAttributesTopic = this.getDeviceAttributesTopic();
        result = result * 59 + ($deviceAttributesTopic == null ? 43 : $deviceAttributesTopic.hashCode());
        String $deviceAttributesSubscribeTopic = this.getDeviceAttributesSubscribeTopic();
        result = result * 59 + ($deviceAttributesSubscribeTopic == null ? 43 : $deviceAttributesSubscribeTopic.hashCode());
        TransportPayloadTypeConfiguration $transportPayloadTypeConfiguration = this.getTransportPayloadTypeConfiguration();
        result = result * 59 + ($transportPayloadTypeConfiguration == null ? 43 : $transportPayloadTypeConfiguration.hashCode());
        Set<String> $sparkplugAttributesMetricNames = this.getSparkplugAttributesMetricNames();
        result = result * 59 + ($sparkplugAttributesMetricNames == null ? 43 : ((Object)$sparkplugAttributesMetricNames).hashCode());
        return result;
    }

    public String toString() {
        return "MqttDeviceProfileTransportConfiguration(deviceTelemetryTopic=" + this.getDeviceTelemetryTopic() + ", deviceAttributesTopic=" + this.getDeviceAttributesTopic() + ", deviceAttributesSubscribeTopic=" + this.getDeviceAttributesSubscribeTopic() + ", transportPayloadTypeConfiguration=" + this.getTransportPayloadTypeConfiguration() + ", sparkplug=" + this.isSparkplug() + ", sparkplugAttributesMetricNames=" + this.getSparkplugAttributesMetricNames() + ", sendAckOnValidationException=" + this.isSendAckOnValidationException() + ")";
    }
}

