/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import java.util.Collection;
import java.util.Optional;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.alarm.AlarmSearchStatus;
import org.thingsboard.server.common.data.alarm.AlarmStatus;

public class AlarmStatusFilter {
    private static final AlarmStatusFilter EMPTY = new AlarmStatusFilter(Optional.empty(), Optional.empty());
    private final Optional<Boolean> clearFilter;
    private final Optional<Boolean> ackFilter;

    private AlarmStatusFilter(Optional<Boolean> clearFilter, Optional<Boolean> ackFilter) {
        this.clearFilter = clearFilter;
        this.ackFilter = ackFilter;
    }

    public static AlarmStatusFilter from(AlarmQuery query) {
        if (query.getSearchStatus() != null) {
            return AlarmStatusFilter.from(query.getSearchStatus());
        }
        if (query.getStatus() != null) {
            return AlarmStatusFilter.from(query.getStatus());
        }
        return AlarmStatusFilter.empty();
    }

    public static AlarmStatusFilter from(AlarmSearchStatus alarmSearchStatus) {
        switch (alarmSearchStatus) {
            case ACK: {
                return new AlarmStatusFilter(Optional.empty(), Optional.of(true));
            }
            case UNACK: {
                return new AlarmStatusFilter(Optional.empty(), Optional.of(false));
            }
            case ACTIVE: {
                return new AlarmStatusFilter(Optional.of(false), Optional.empty());
            }
            case CLEARED: {
                return new AlarmStatusFilter(Optional.of(true), Optional.empty());
            }
        }
        return EMPTY;
    }

    public static AlarmStatusFilter from(AlarmStatus alarmStatus) {
        switch (alarmStatus) {
            case ACTIVE_UNACK: {
                return new AlarmStatusFilter(Optional.of(false), Optional.of(false));
            }
            case ACTIVE_ACK: {
                return new AlarmStatusFilter(Optional.of(false), Optional.of(true));
            }
            case CLEARED_UNACK: {
                return new AlarmStatusFilter(Optional.of(true), Optional.of(false));
            }
            case CLEARED_ACK: {
                return new AlarmStatusFilter(Optional.of(true), Optional.of(true));
            }
        }
        return EMPTY;
    }

    public static AlarmStatusFilter empty() {
        return EMPTY;
    }

    public boolean hasAnyFilter() {
        return this.clearFilter.isPresent() || this.ackFilter.isPresent();
    }

    public boolean hasClearFilter() {
        return this.clearFilter.isPresent();
    }

    public boolean hasAckFilter() {
        return this.ackFilter.isPresent();
    }

    public boolean getClearFilter() {
        return this.clearFilter.orElseThrow(() -> new RuntimeException("Clear filter is not set! Use `hasClearFilter` to check."));
    }

    public boolean getAckFilter() {
        return this.ackFilter.orElseThrow(() -> new RuntimeException("Ack filter is not set! Use `hasAckFilter` to check."));
    }

    public static AlarmStatusFilter from(Collection<AlarmSearchStatus> statuses) {
        if (statuses == null || statuses.isEmpty() || statuses.contains((Object)AlarmSearchStatus.ANY)) {
            return EMPTY;
        }
        boolean clearFilter = statuses.contains((Object)AlarmSearchStatus.CLEARED);
        boolean activeFilter = statuses.contains((Object)AlarmSearchStatus.ACTIVE);
        Optional<Boolean> clear = Optional.empty();
        if (clearFilter && !activeFilter || !clearFilter && activeFilter) {
            clear = Optional.of(clearFilter);
        }
        boolean ackFilter = statuses.contains((Object)AlarmSearchStatus.ACK);
        boolean unackFilter = statuses.contains((Object)AlarmSearchStatus.UNACK);
        Optional<Boolean> ack = Optional.empty();
        if (ackFilter && !unackFilter || !ackFilter && unackFilter) {
            ack = Optional.of(ackFilter);
        }
        return new AlarmStatusFilter(clear, ack);
    }

    public boolean matches(Alarm alarm) {
        return this.ackFilter.map(ackFilter -> ackFilter.equals(alarm.isAcknowledged())).orElse(true) != false && this.clearFilter.map(clearedFilter -> clearedFilter.equals(alarm.isCleared())).orElse(true) != false;
    }
}

