/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.alarm;

import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.thingsboard.server.common.data.validation.NoXss;

public class AlarmPropagationInfo {
    public static AlarmPropagationInfo EMPTY = new AlarmPropagationInfo(false, false, false, Collections.emptyList());
    @ApiModelProperty(position=1, value="Propagation flag to specify if alarm should be propagated to parent entities of alarm originator", example="true")
    private boolean propagate;
    @ApiModelProperty(position=2, value="Propagation flag to specify if alarm should be propagated to the owner (tenant or customer) of alarm originator", example="true")
    private boolean propagateToOwner;
    @ApiModelProperty(position=3, value="Propagation flag to specify if alarm should be propagated to the tenant entity", example="true")
    private boolean propagateToTenant;
    @NoXss
    @ApiModelProperty(position=4, value="JSON array of relation types that should be used for propagation. By default, 'propagateRelationTypes' array is empty which means that the alarm will be propagated based on any relation type to parent entities. This parameter should be used only in case when 'propagate' parameter is set to true, otherwise, 'propagateRelationTypes' array will be ignored.")
    private List<String> propagateRelationTypes;

    @ConstructorProperties(value={"propagate", "propagateToOwner", "propagateToTenant", "propagateRelationTypes"})
    AlarmPropagationInfo(boolean propagate, boolean propagateToOwner, boolean propagateToTenant, List<String> propagateRelationTypes) {
        this.propagate = propagate;
        this.propagateToOwner = propagateToOwner;
        this.propagateToTenant = propagateToTenant;
        this.propagateRelationTypes = propagateRelationTypes;
    }

    public static AlarmPropagationInfoBuilder builder() {
        return new AlarmPropagationInfoBuilder();
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    public boolean isPropagateToOwner() {
        return this.propagateToOwner;
    }

    public boolean isPropagateToTenant() {
        return this.propagateToTenant;
    }

    public List<String> getPropagateRelationTypes() {
        return this.propagateRelationTypes;
    }

    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    public void setPropagateToOwner(boolean propagateToOwner) {
        this.propagateToOwner = propagateToOwner;
    }

    public void setPropagateToTenant(boolean propagateToTenant) {
        this.propagateToTenant = propagateToTenant;
    }

    public void setPropagateRelationTypes(List<String> propagateRelationTypes) {
        this.propagateRelationTypes = propagateRelationTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmPropagationInfo)) {
            return false;
        }
        AlarmPropagationInfo other = (AlarmPropagationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPropagate() != other.isPropagate()) {
            return false;
        }
        if (this.isPropagateToOwner() != other.isPropagateToOwner()) {
            return false;
        }
        if (this.isPropagateToTenant() != other.isPropagateToTenant()) {
            return false;
        }
        List<String> this$propagateRelationTypes = this.getPropagateRelationTypes();
        List<String> other$propagateRelationTypes = other.getPropagateRelationTypes();
        return !(this$propagateRelationTypes == null ? other$propagateRelationTypes != null : !((Object)this$propagateRelationTypes).equals(other$propagateRelationTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmPropagationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPropagate() ? 79 : 97);
        result = result * 59 + (this.isPropagateToOwner() ? 79 : 97);
        result = result * 59 + (this.isPropagateToTenant() ? 79 : 97);
        List<String> $propagateRelationTypes = this.getPropagateRelationTypes();
        result = result * 59 + ($propagateRelationTypes == null ? 43 : ((Object)$propagateRelationTypes).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmPropagationInfo(propagate=" + this.isPropagate() + ", propagateToOwner=" + this.isPropagateToOwner() + ", propagateToTenant=" + this.isPropagateToTenant() + ", propagateRelationTypes=" + this.getPropagateRelationTypes() + ")";
    }

    public static class AlarmPropagationInfoBuilder {
        private boolean propagate;
        private boolean propagateToOwner;
        private boolean propagateToTenant;
        private List<String> propagateRelationTypes;

        AlarmPropagationInfoBuilder() {
        }

        public AlarmPropagationInfoBuilder propagate(boolean propagate) {
            this.propagate = propagate;
            return this;
        }

        public AlarmPropagationInfoBuilder propagateToOwner(boolean propagateToOwner) {
            this.propagateToOwner = propagateToOwner;
            return this;
        }

        public AlarmPropagationInfoBuilder propagateToTenant(boolean propagateToTenant) {
            this.propagateToTenant = propagateToTenant;
            return this;
        }

        public AlarmPropagationInfoBuilder propagateRelationTypes(List<String> propagateRelationTypes) {
            this.propagateRelationTypes = propagateRelationTypes;
            return this;
        }

        public AlarmPropagationInfo build() {
            return new AlarmPropagationInfo(this.propagate, this.propagateToOwner, this.propagateToTenant, this.propagateRelationTypes);
        }

        public String toString() {
            return "AlarmPropagationInfo.AlarmPropagationInfoBuilder(propagate=" + this.propagate + ", propagateToOwner=" + this.propagateToOwner + ", propagateToTenant=" + this.propagateToTenant + ", propagateRelationTypes=" + this.propagateRelationTypes + ")";
        }
    }
}

