/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class Tenant
extends ContactBased<TenantId>
implements HasTenantId,
HasTitle {
    private static final long serialVersionUID = 8057243243859922101L;
    @Length(fieldName="title")
    @NoXss
    @ApiModelProperty(position=3, value="Title of the tenant", example="Company A")
    private String title;
    @NoXss
    @Length(fieldName="region")
    @ApiModelProperty(position=5, value="Geo region of the tenant", example="North America")
    private String region;
    @ApiModelProperty(position=6, required=true, value="JSON object with Tenant Profile Id")
    private TenantProfileId tenantProfileId;

    public Tenant() {
    }

    public Tenant(TenantId id) {
        super(id);
    }

    public Tenant(Tenant tenant) {
        super(tenant);
        this.title = tenant.getTitle();
        this.region = tenant.getRegion();
        this.tenantProfileId = tenant.getTenantProfileId();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @JsonIgnore
    public TenantId getTenantId() {
        return this.getId();
    }

    @Override
    @ApiModelProperty(position=4, value="Name of the tenant. Read-only, duplicated from title for backward compatibility", example="Company A", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public TenantProfileId getTenantProfileId() {
        return this.tenantProfileId;
    }

    public void setTenantProfileId(TenantProfileId tenantProfileId) {
        this.tenantProfileId = tenantProfileId;
    }

    @Override
    public String getSearchText() {
        return this.getTitle();
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the tenant Id. Specify this field to update the tenant. Referencing non-existing tenant Id will cause error. Omit this field to create new tenant.")
    public TenantId getId() {
        return (TenantId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the tenant creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=7, required=true, value="Country", example="US")
    public String getCountry() {
        return super.getCountry();
    }

    @Override
    @ApiModelProperty(position=8, required=true, value="State", example="NY")
    public String getState() {
        return super.getState();
    }

    @Override
    @ApiModelProperty(position=9, required=true, value="City", example="New York")
    public String getCity() {
        return super.getCity();
    }

    @Override
    @ApiModelProperty(position=10, required=true, value="Address Line 1", example="42 Broadway Suite 12-400")
    public String getAddress() {
        return super.getAddress();
    }

    @Override
    @ApiModelProperty(position=11, required=true, value="Address Line 2", example="")
    public String getAddress2() {
        return super.getAddress2();
    }

    @Override
    @ApiModelProperty(position=12, required=true, value="Zip code", example="10004")
    public String getZip() {
        return super.getZip();
    }

    @Override
    @ApiModelProperty(position=13, required=true, value="Phone number", example="+1(415)777-7777")
    public String getPhone() {
        return super.getPhone();
    }

    @Override
    @ApiModelProperty(position=14, required=true, value="Email", example="example@company.com")
    public String getEmail() {
        return super.getEmail();
    }

    @Override
    @ApiModelProperty(position=15, value="Additional parameters of the device", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Tenant [title=");
        builder.append(this.title);
        builder.append(", region=");
        builder.append(this.region);
        builder.append(", tenantProfileId=");
        builder.append(this.tenantProfileId);
        builder.append(", additionalInfo=");
        builder.append(this.getAdditionalInfo());
        builder.append(", country=");
        builder.append(this.country);
        builder.append(", state=");
        builder.append(this.state);
        builder.append(", city=");
        builder.append(this.city);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", address2=");
        builder.append(this.address2);
        builder.append(", zip=");
        builder.append(this.zip);
        builder.append(", phone=");
        builder.append(this.phone);
        builder.append(", email=");
        builder.append(this.email);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        TenantProfileId this$tenantProfileId = this.getTenantProfileId();
        TenantProfileId other$tenantProfileId = other.getTenantProfileId();
        return !(this$tenantProfileId == null ? other$tenantProfileId != null : !((Object)this$tenantProfileId).equals(other$tenantProfileId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Tenant;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        TenantProfileId $tenantProfileId = this.getTenantProfileId();
        result = result * 59 + ($tenantProfileId == null ? 43 : ((Object)$tenantProfileId).hashCode());
        return result;
    }
}

