/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.id.DeviceId;

@ApiModel
public class DeviceInfo
extends Device {
    private static final long serialVersionUID = -3004579925090663691L;
    @ApiModelProperty(position=13, value="Title of the Customer that owns the device.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String customerTitle;
    @ApiModelProperty(position=14, value="Indicates special 'Public' Customer that is auto-generated to use the devices on public dashboards.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private boolean customerIsPublic;
    @ApiModelProperty(position=15, value="Name of the corresponding Device Profile.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private String deviceProfileName;
    @ApiModelProperty(position=16, value="Device active flag.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    private boolean active;

    public DeviceInfo() {
    }

    public DeviceInfo(DeviceId deviceId) {
        super(deviceId);
    }

    public DeviceInfo(Device device, String customerTitle, boolean customerIsPublic, String deviceProfileName, boolean active) {
        super(device);
        this.customerTitle = customerTitle;
        this.customerIsPublic = customerIsPublic;
        this.deviceProfileName = deviceProfileName;
        this.active = active;
    }

    public String getCustomerTitle() {
        return this.customerTitle;
    }

    public boolean isCustomerIsPublic() {
        return this.customerIsPublic;
    }

    public String getDeviceProfileName() {
        return this.deviceProfileName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setCustomerTitle(String customerTitle) {
        this.customerTitle = customerTitle;
    }

    public void setCustomerIsPublic(boolean customerIsPublic) {
        this.customerIsPublic = customerIsPublic;
    }

    public void setDeviceProfileName(String deviceProfileName) {
        this.deviceProfileName = deviceProfileName;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String toString() {
        return "DeviceInfo(customerTitle=" + this.getCustomerTitle() + ", customerIsPublic=" + this.isCustomerIsPublic() + ", deviceProfileName=" + this.getDeviceProfileName() + ", active=" + this.isActive() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCustomerIsPublic() != other.isCustomerIsPublic()) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$customerTitle = this.getCustomerTitle();
        String other$customerTitle = other.getCustomerTitle();
        if (this$customerTitle == null ? other$customerTitle != null : !this$customerTitle.equals(other$customerTitle)) {
            return false;
        }
        String this$deviceProfileName = this.getDeviceProfileName();
        String other$deviceProfileName = other.getDeviceProfileName();
        return !(this$deviceProfileName == null ? other$deviceProfileName != null : !this$deviceProfileName.equals(other$deviceProfileName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeviceInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCustomerIsPublic() ? 79 : 97);
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $customerTitle = this.getCustomerTitle();
        result = result * 59 + ($customerTitle == null ? 43 : $customerTitle.hashCode());
        String $deviceProfileName = this.getDeviceProfileName();
        result = result * 59 + ($deviceProfileName == null ? 43 : $deviceProfileName.hashCode());
        return result;
    }
}

