/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasLabel;
import org.thingsboard.server.common.data.HasOtaPackage;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.device.data.DeviceData;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@ApiModel
public class Device
extends SearchTextBasedWithAdditionalInfo<DeviceId>
implements HasLabel,
HasTenantId,
HasCustomerId,
HasOtaPackage,
ExportableEntity<DeviceId> {
    private static final Logger log = LoggerFactory.getLogger(Device.class);
    private static final long serialVersionUID = 2807343040519543363L;
    private TenantId tenantId;
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="name")
    private String name;
    @NoXss
    @Length(fieldName="type")
    private String type;
    @NoXss
    @Length(fieldName="label")
    private String label;
    private DeviceProfileId deviceProfileId;
    private transient DeviceData deviceData;
    @JsonIgnore
    private byte[] deviceDataBytes;
    private OtaPackageId firmwareId;
    private OtaPackageId softwareId;
    private DeviceId externalId;

    public Device() {
    }

    public Device(DeviceId id) {
        super(id);
    }

    public Device(Device device) {
        super(device);
        this.tenantId = device.getTenantId();
        this.customerId = device.getCustomerId();
        this.name = device.getName();
        this.type = device.getType();
        this.label = device.getLabel();
        this.deviceProfileId = device.getDeviceProfileId();
        this.setDeviceData(device.getDeviceData());
        this.firmwareId = device.getFirmwareId();
        this.softwareId = device.getSoftwareId();
        this.externalId = device.getExternalId();
    }

    public Device updateDevice(Device device) {
        this.tenantId = device.getTenantId();
        this.customerId = device.getCustomerId();
        this.name = device.getName();
        this.type = device.getType();
        this.label = device.getLabel();
        this.deviceProfileId = device.getDeviceProfileId();
        this.setDeviceData(device.getDeviceData());
        this.setFirmwareId(device.getFirmwareId());
        this.setSoftwareId(device.getSoftwareId());
        Optional.ofNullable(device.getAdditionalInfo()).ifPresent(this::setAdditionalInfo);
        this.setExternalId(device.getExternalId());
        return this;
    }

    @Override
    @ApiModelProperty(position=1, value="JSON object with the Device Id. Specify this field to update the Device. Referencing non-existing Device Id will cause error. Omit this field to create new Device.")
    public DeviceId getId() {
        return (DeviceId)super.getId();
    }

    @Override
    @ApiModelProperty(position=2, value="Timestamp of the device creation, in milliseconds", example="1609459200000", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @ApiModelProperty(position=3, value="JSON object with Tenant Id. Use 'assignDeviceToTenant' to change the Tenant Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @ApiModelProperty(position=4, value="JSON object with Customer Id. Use 'assignDeviceToCustomer' to change the Customer Id.", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Override
    @ApiModelProperty(position=5, required=true, value="Unique Device Name in scope of Tenant", example="A4B72CCDFF33")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=6, required=true, value="Device Profile Name", example="Temperature Sensor")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    @ApiModelProperty(position=7, required=true, value="Label that may be used in widgets", example="Room 234 Sensor")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @ApiModelProperty(position=8, required=true, value="JSON object with Device Profile Id.")
    public DeviceProfileId getDeviceProfileId() {
        return this.deviceProfileId;
    }

    public void setDeviceProfileId(DeviceProfileId deviceProfileId) {
        this.deviceProfileId = deviceProfileId;
    }

    @ApiModelProperty(position=9, value="JSON object with content specific to type of transport in the device profile.")
    public DeviceData getDeviceData() {
        if (this.deviceData != null) {
            return this.deviceData;
        }
        if (this.deviceDataBytes != null) {
            try {
                this.deviceData = (DeviceData)mapper.readValue((InputStream)new ByteArrayInputStream(this.deviceDataBytes), DeviceData.class);
            }
            catch (IOException e) {
                log.warn("Can't deserialize device data: ", (Throwable)e);
                return null;
            }
            return this.deviceData;
        }
        return null;
    }

    public void setDeviceData(DeviceData data) {
        this.deviceData = data;
        try {
            this.deviceDataBytes = data != null ? mapper.writeValueAsBytes((Object)data) : null;
        }
        catch (JsonProcessingException e) {
            log.warn("Can't serialize device data: ", (Throwable)e);
        }
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    @ApiModelProperty(position=10, value="JSON object with Ota Package Id.")
    public OtaPackageId getFirmwareId() {
        return this.firmwareId;
    }

    public void setFirmwareId(OtaPackageId firmwareId) {
        this.firmwareId = firmwareId;
    }

    @Override
    @ApiModelProperty(position=11, value="JSON object with Ota Package Id.")
    public OtaPackageId getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(OtaPackageId softwareId) {
        this.softwareId = softwareId;
    }

    @Override
    @ApiModelProperty(position=12, value="Additional parameters of the device", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Device [tenantId=");
        builder.append(this.tenantId);
        builder.append(", customerId=");
        builder.append(this.customerId);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", label=");
        builder.append(this.label);
        builder.append(", deviceProfileId=");
        builder.append(this.deviceProfileId);
        builder.append(", deviceData=");
        builder.append(this.firmwareId);
        builder.append(", firmwareId=");
        builder.append(this.deviceData);
        builder.append(", additionalInfo=");
        builder.append(this.getAdditionalInfo());
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device other = (Device)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        DeviceProfileId this$deviceProfileId = this.getDeviceProfileId();
        DeviceProfileId other$deviceProfileId = other.getDeviceProfileId();
        if (this$deviceProfileId == null ? other$deviceProfileId != null : !((Object)this$deviceProfileId).equals(other$deviceProfileId)) {
            return false;
        }
        if (!Arrays.equals(this.deviceDataBytes, other.deviceDataBytes)) {
            return false;
        }
        OtaPackageId this$firmwareId = this.getFirmwareId();
        OtaPackageId other$firmwareId = other.getFirmwareId();
        if (this$firmwareId == null ? other$firmwareId != null : !((Object)this$firmwareId).equals(other$firmwareId)) {
            return false;
        }
        OtaPackageId this$softwareId = this.getSoftwareId();
        OtaPackageId other$softwareId = other.getSoftwareId();
        if (this$softwareId == null ? other$softwareId != null : !((Object)this$softwareId).equals(other$softwareId)) {
            return false;
        }
        DeviceId this$externalId = this.getExternalId();
        DeviceId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Device;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        DeviceProfileId $deviceProfileId = this.getDeviceProfileId();
        result = result * 59 + ($deviceProfileId == null ? 43 : ((Object)$deviceProfileId).hashCode());
        result = result * 59 + Arrays.hashCode(this.deviceDataBytes);
        OtaPackageId $firmwareId = this.getFirmwareId();
        result = result * 59 + ($firmwareId == null ? 43 : ((Object)$firmwareId).hashCode());
        OtaPackageId $softwareId = this.getSoftwareId();
        result = result * 59 + ($softwareId == null ? 43 : ((Object)$softwareId).hashCode());
        DeviceId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    public DeviceId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(DeviceId externalId) {
        this.externalId = externalId;
    }
}

