/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Streams;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.id.DashboardId;

public class Dashboard
extends DashboardInfo
implements ExportableEntity<DashboardId> {
    private static final long serialVersionUID = 872682138346187503L;
    private transient JsonNode configuration;
    private DashboardId externalId;

    public Dashboard() {
    }

    public Dashboard(DashboardId id) {
        super(id);
    }

    public Dashboard(DashboardInfo dashboardInfo) {
        super(dashboardInfo);
    }

    public Dashboard(Dashboard dashboard) {
        super(dashboard);
        this.configuration = dashboard.getConfiguration();
        this.externalId = dashboard.getExternalId();
    }

    @ApiModelProperty(position=9, value="JSON object with main configuration of the dashboard: layouts, widgets, aliases, etc. The JSON structure of the dashboard configuration is quite complex. The easiest way to learn it is to export existing dashboard to JSON.", dataType="com.fasterxml.jackson.databind.JsonNode")
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @JsonIgnore
    public List<ObjectNode> getEntityAliasesConfig() {
        return this.getChildObjects("entityAliases");
    }

    @JsonIgnore
    public List<ObjectNode> getWidgetsConfig() {
        return this.getChildObjects("widgets");
    }

    @JsonIgnore
    private List<ObjectNode> getChildObjects(String propertyName) {
        return Optional.ofNullable(this.configuration).map(config -> config.get(propertyName)).filter(node -> !node.isEmpty() && (node.isObject() || node.isArray())).map(node -> Streams.stream((Iterator)node.elements()).filter(JsonNode::isObject).map(jsonNode -> (ObjectNode)jsonNode).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dashboard [tenantId=");
        builder.append(this.getTenantId());
        builder.append(", title=");
        builder.append(this.getTitle());
        builder.append(", configuration=");
        builder.append(this.configuration);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dashboard)) {
            return false;
        }
        Dashboard other = (Dashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DashboardId this$externalId = this.getExternalId();
        DashboardId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dashboard;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DashboardId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }

    @Override
    public DashboardId getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(DashboardId externalId) {
        this.externalId = externalId;
    }
}

