/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.ApiUsageStateId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public class ApiUsageState
extends BaseData<ApiUsageStateId>
implements HasTenantId {
    private static final long serialVersionUID = 8250339805336035966L;
    private TenantId tenantId;
    private EntityId entityId;
    private ApiUsageStateValue transportState;
    private ApiUsageStateValue dbStorageState;
    private ApiUsageStateValue reExecState;
    private ApiUsageStateValue jsExecState;
    private ApiUsageStateValue emailExecState;
    private ApiUsageStateValue smsExecState;
    private ApiUsageStateValue alarmExecState;

    public ApiUsageState() {
    }

    public ApiUsageState(ApiUsageStateId id) {
        super(id);
    }

    public ApiUsageState(ApiUsageState ur) {
        super(ur);
        this.tenantId = ur.getTenantId();
        this.entityId = ur.getEntityId();
        this.transportState = ur.getTransportState();
        this.dbStorageState = ur.getDbStorageState();
        this.reExecState = ur.getReExecState();
        this.jsExecState = ur.getJsExecState();
        this.emailExecState = ur.getEmailExecState();
        this.smsExecState = ur.getSmsExecState();
        this.alarmExecState = ur.getAlarmExecState();
    }

    public boolean isTransportEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.transportState);
    }

    public boolean isReExecEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.reExecState);
    }

    public boolean isDbStorageEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.dbStorageState);
    }

    public boolean isJsExecEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.jsExecState);
    }

    public boolean isEmailSendEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.emailExecState);
    }

    public boolean isSmsSendEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.smsExecState);
    }

    public boolean isAlarmCreationEnabled() {
        return this.alarmExecState != ApiUsageStateValue.DISABLED;
    }

    @Override
    public String toString() {
        return "ApiUsageState(tenantId=" + this.getTenantId() + ", entityId=" + this.getEntityId() + ", transportState=" + this.getTransportState() + ", dbStorageState=" + this.getDbStorageState() + ", reExecState=" + this.getReExecState() + ", jsExecState=" + this.getJsExecState() + ", emailExecState=" + this.getEmailExecState() + ", smsExecState=" + this.getSmsExecState() + ", alarmExecState=" + this.getAlarmExecState() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiUsageState)) {
            return false;
        }
        ApiUsageState other = (ApiUsageState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        ApiUsageStateValue this$transportState = this.getTransportState();
        ApiUsageStateValue other$transportState = other.getTransportState();
        if (this$transportState == null ? other$transportState != null : !((Object)((Object)this$transportState)).equals((Object)other$transportState)) {
            return false;
        }
        ApiUsageStateValue this$dbStorageState = this.getDbStorageState();
        ApiUsageStateValue other$dbStorageState = other.getDbStorageState();
        if (this$dbStorageState == null ? other$dbStorageState != null : !((Object)((Object)this$dbStorageState)).equals((Object)other$dbStorageState)) {
            return false;
        }
        ApiUsageStateValue this$reExecState = this.getReExecState();
        ApiUsageStateValue other$reExecState = other.getReExecState();
        if (this$reExecState == null ? other$reExecState != null : !((Object)((Object)this$reExecState)).equals((Object)other$reExecState)) {
            return false;
        }
        ApiUsageStateValue this$jsExecState = this.getJsExecState();
        ApiUsageStateValue other$jsExecState = other.getJsExecState();
        if (this$jsExecState == null ? other$jsExecState != null : !((Object)((Object)this$jsExecState)).equals((Object)other$jsExecState)) {
            return false;
        }
        ApiUsageStateValue this$emailExecState = this.getEmailExecState();
        ApiUsageStateValue other$emailExecState = other.getEmailExecState();
        if (this$emailExecState == null ? other$emailExecState != null : !((Object)((Object)this$emailExecState)).equals((Object)other$emailExecState)) {
            return false;
        }
        ApiUsageStateValue this$smsExecState = this.getSmsExecState();
        ApiUsageStateValue other$smsExecState = other.getSmsExecState();
        if (this$smsExecState == null ? other$smsExecState != null : !((Object)((Object)this$smsExecState)).equals((Object)other$smsExecState)) {
            return false;
        }
        ApiUsageStateValue this$alarmExecState = this.getAlarmExecState();
        ApiUsageStateValue other$alarmExecState = other.getAlarmExecState();
        return !(this$alarmExecState == null ? other$alarmExecState != null : !((Object)((Object)this$alarmExecState)).equals((Object)other$alarmExecState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiUsageState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        ApiUsageStateValue $transportState = this.getTransportState();
        result = result * 59 + ($transportState == null ? 43 : ((Object)((Object)$transportState)).hashCode());
        ApiUsageStateValue $dbStorageState = this.getDbStorageState();
        result = result * 59 + ($dbStorageState == null ? 43 : ((Object)((Object)$dbStorageState)).hashCode());
        ApiUsageStateValue $reExecState = this.getReExecState();
        result = result * 59 + ($reExecState == null ? 43 : ((Object)((Object)$reExecState)).hashCode());
        ApiUsageStateValue $jsExecState = this.getJsExecState();
        result = result * 59 + ($jsExecState == null ? 43 : ((Object)((Object)$jsExecState)).hashCode());
        ApiUsageStateValue $emailExecState = this.getEmailExecState();
        result = result * 59 + ($emailExecState == null ? 43 : ((Object)((Object)$emailExecState)).hashCode());
        ApiUsageStateValue $smsExecState = this.getSmsExecState();
        result = result * 59 + ($smsExecState == null ? 43 : ((Object)((Object)$smsExecState)).hashCode());
        ApiUsageStateValue $alarmExecState = this.getAlarmExecState();
        result = result * 59 + ($alarmExecState == null ? 43 : ((Object)((Object)$alarmExecState)).hashCode());
        return result;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public ApiUsageStateValue getTransportState() {
        return this.transportState;
    }

    public ApiUsageStateValue getDbStorageState() {
        return this.dbStorageState;
    }

    public ApiUsageStateValue getReExecState() {
        return this.reExecState;
    }

    public ApiUsageStateValue getJsExecState() {
        return this.jsExecState;
    }

    public ApiUsageStateValue getEmailExecState() {
        return this.emailExecState;
    }

    public ApiUsageStateValue getSmsExecState() {
        return this.smsExecState;
    }

    public ApiUsageStateValue getAlarmExecState() {
        return this.alarmExecState;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setTransportState(ApiUsageStateValue transportState) {
        this.transportState = transportState;
    }

    public void setDbStorageState(ApiUsageStateValue dbStorageState) {
        this.dbStorageState = dbStorageState;
    }

    public void setReExecState(ApiUsageStateValue reExecState) {
        this.reExecState = reExecState;
    }

    public void setJsExecState(ApiUsageStateValue jsExecState) {
        this.jsExecState = jsExecState;
    }

    public void setEmailExecState(ApiUsageStateValue emailExecState) {
        this.emailExecState = emailExecState;
    }

    public void setSmsExecState(ApiUsageStateValue smsExecState) {
        this.smsExecState = smsExecState;
    }

    public void setAlarmExecState(ApiUsageStateValue alarmExecState) {
        this.alarmExecState = alarmExecState;
    }
}

