/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.translation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.thingsboard.server.common.data.JacksonUtils;

public class CustomTranslation {
    private static final Logger log = Logger.getLogger(CustomTranslation.class);
    private Map<String, String> translationMap = new HashMap<String, String>();
    private static ObjectMapper mapper = new ObjectMapper();

    public CustomTranslation merge(CustomTranslation otherCL) {
        ArrayList<String> languages = new ArrayList<String>();
        languages.addAll(this.translationMap.keySet());
        if (otherCL != null && otherCL.getTranslationMap() != null) {
            languages.addAll(otherCL.getTranslationMap().keySet());
            for (String lang : languages) {
                JsonNode node = this.safeParse(this.translationMap.get(lang));
                JsonNode otherNode = this.safeParse(otherCL.getTranslationMap().get(lang));
                node = JacksonUtils.merge(node, otherNode);
                try {
                    this.translationMap.put(lang, mapper.writeValueAsString((Object)node));
                }
                catch (JsonProcessingException e) {
                    log.warn((Object)"Can't write object as json string", (Throwable)e);
                }
            }
        }
        return this;
    }

    private JsonNode safeParse(String jsonStr) {
        ObjectNode node = mapper.createObjectNode();
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{jsonStr})) {
                node = mapper.readTree(jsonStr);
            }
        }
        catch (IOException e) {
            log.warn((Object)"Can't read json string", (Throwable)e);
        }
        return node;
    }

    public Map<String, String> getTranslationMap() {
        return this.translationMap;
    }

    public void setTranslationMap(Map<String, String> translationMap) {
        this.translationMap = translationMap;
    }

    public String toString() {
        return "CustomTranslation(translationMap=" + this.getTranslationMap() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomTranslation)) {
            return false;
        }
        CustomTranslation other = (CustomTranslation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$translationMap = this.getTranslationMap();
        Map<String, String> other$translationMap = other.getTranslationMap();
        return !(this$translationMap == null ? other$translationMap != null : !((Object)this$translationMap).equals(other$translationMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomTranslation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $translationMap = this.getTranslationMap();
        result = result * 59 + ($translationMap == null ? 43 : ((Object)$translationMap).hashCode());
        return result;
    }
}

