/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.tenant.profile;

import java.beans.ConstructorProperties;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.TenantProfileType;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;

public class DefaultTenantProfileConfiguration
implements TenantProfileConfiguration {
    private long maxDevices;
    private long maxAssets;
    private long maxCustomers;
    private long maxUsers;
    private long maxDashboards;
    private long maxRuleChains;
    private long maxResourcesInBytes;
    private long maxOtaPackagesInBytes;
    private long maxIntegrations;
    private long maxConverters;
    private long maxSchedulerEvents;
    private String transportTenantMsgRateLimit;
    private String transportTenantTelemetryMsgRateLimit;
    private String transportTenantTelemetryDataPointsRateLimit;
    private String transportDeviceMsgRateLimit;
    private String transportDeviceTelemetryMsgRateLimit;
    private String transportDeviceTelemetryDataPointsRateLimit;
    private long maxTransportMessages;
    private long maxTransportDataPoints;
    private long maxREExecutions;
    private long maxJSExecutions;
    private long maxDPStorageDays;
    private int maxRuleNodeExecutionsPerMessage;
    private long maxEmails;
    private long maxSms;
    private long maxCreatedAlarms;
    private int defaultStorageTtlDays;
    private int alarmsTtlDays;
    private int rpcTtlDays;
    private double warnThreshold;

    @Override
    public long getProfileThreshold(ApiUsageRecordKey key) {
        switch (key) {
            case TRANSPORT_MSG_COUNT: {
                return this.maxTransportMessages;
            }
            case TRANSPORT_DP_COUNT: {
                return this.maxTransportDataPoints;
            }
            case JS_EXEC_COUNT: {
                return this.maxJSExecutions;
            }
            case RE_EXEC_COUNT: {
                return this.maxREExecutions;
            }
            case STORAGE_DP_COUNT: {
                return this.maxDPStorageDays;
            }
            case EMAIL_EXEC_COUNT: {
                return this.maxEmails;
            }
            case SMS_EXEC_COUNT: {
                return this.maxSms;
            }
            case CREATED_ALARMS_COUNT: {
                return this.maxCreatedAlarms;
            }
        }
        return 0L;
    }

    @Override
    public long getWarnThreshold(ApiUsageRecordKey key) {
        return (long)((double)this.getProfileThreshold(key) * (this.warnThreshold > 0.0 ? this.warnThreshold : 0.8));
    }

    @Override
    public TenantProfileType getType() {
        return TenantProfileType.DEFAULT;
    }

    @Override
    public int getMaxRuleNodeExecsPerMessage() {
        return this.maxRuleNodeExecutionsPerMessage;
    }

    public static DefaultTenantProfileConfigurationBuilder builder() {
        return new DefaultTenantProfileConfigurationBuilder();
    }

    @ConstructorProperties(value={"maxDevices", "maxAssets", "maxCustomers", "maxUsers", "maxDashboards", "maxRuleChains", "maxResourcesInBytes", "maxOtaPackagesInBytes", "maxIntegrations", "maxConverters", "maxSchedulerEvents", "transportTenantMsgRateLimit", "transportTenantTelemetryMsgRateLimit", "transportTenantTelemetryDataPointsRateLimit", "transportDeviceMsgRateLimit", "transportDeviceTelemetryMsgRateLimit", "transportDeviceTelemetryDataPointsRateLimit", "maxTransportMessages", "maxTransportDataPoints", "maxREExecutions", "maxJSExecutions", "maxDPStorageDays", "maxRuleNodeExecutionsPerMessage", "maxEmails", "maxSms", "maxCreatedAlarms", "defaultStorageTtlDays", "alarmsTtlDays", "rpcTtlDays", "warnThreshold"})
    public DefaultTenantProfileConfiguration(long maxDevices, long maxAssets, long maxCustomers, long maxUsers, long maxDashboards, long maxRuleChains, long maxResourcesInBytes, long maxOtaPackagesInBytes, long maxIntegrations, long maxConverters, long maxSchedulerEvents, String transportTenantMsgRateLimit, String transportTenantTelemetryMsgRateLimit, String transportTenantTelemetryDataPointsRateLimit, String transportDeviceMsgRateLimit, String transportDeviceTelemetryMsgRateLimit, String transportDeviceTelemetryDataPointsRateLimit, long maxTransportMessages, long maxTransportDataPoints, long maxREExecutions, long maxJSExecutions, long maxDPStorageDays, int maxRuleNodeExecutionsPerMessage, long maxEmails, long maxSms, long maxCreatedAlarms, int defaultStorageTtlDays, int alarmsTtlDays, int rpcTtlDays, double warnThreshold) {
        this.maxDevices = maxDevices;
        this.maxAssets = maxAssets;
        this.maxCustomers = maxCustomers;
        this.maxUsers = maxUsers;
        this.maxDashboards = maxDashboards;
        this.maxRuleChains = maxRuleChains;
        this.maxResourcesInBytes = maxResourcesInBytes;
        this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
        this.maxIntegrations = maxIntegrations;
        this.maxConverters = maxConverters;
        this.maxSchedulerEvents = maxSchedulerEvents;
        this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
        this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
        this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
        this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
        this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
        this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
        this.maxTransportMessages = maxTransportMessages;
        this.maxTransportDataPoints = maxTransportDataPoints;
        this.maxREExecutions = maxREExecutions;
        this.maxJSExecutions = maxJSExecutions;
        this.maxDPStorageDays = maxDPStorageDays;
        this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
        this.maxEmails = maxEmails;
        this.maxSms = maxSms;
        this.maxCreatedAlarms = maxCreatedAlarms;
        this.defaultStorageTtlDays = defaultStorageTtlDays;
        this.alarmsTtlDays = alarmsTtlDays;
        this.rpcTtlDays = rpcTtlDays;
        this.warnThreshold = warnThreshold;
    }

    public DefaultTenantProfileConfiguration() {
    }

    public long getMaxDevices() {
        return this.maxDevices;
    }

    public long getMaxAssets() {
        return this.maxAssets;
    }

    public long getMaxCustomers() {
        return this.maxCustomers;
    }

    public long getMaxUsers() {
        return this.maxUsers;
    }

    public long getMaxDashboards() {
        return this.maxDashboards;
    }

    public long getMaxRuleChains() {
        return this.maxRuleChains;
    }

    public long getMaxResourcesInBytes() {
        return this.maxResourcesInBytes;
    }

    public long getMaxOtaPackagesInBytes() {
        return this.maxOtaPackagesInBytes;
    }

    public long getMaxIntegrations() {
        return this.maxIntegrations;
    }

    public long getMaxConverters() {
        return this.maxConverters;
    }

    public long getMaxSchedulerEvents() {
        return this.maxSchedulerEvents;
    }

    public String getTransportTenantMsgRateLimit() {
        return this.transportTenantMsgRateLimit;
    }

    public String getTransportTenantTelemetryMsgRateLimit() {
        return this.transportTenantTelemetryMsgRateLimit;
    }

    public String getTransportTenantTelemetryDataPointsRateLimit() {
        return this.transportTenantTelemetryDataPointsRateLimit;
    }

    public String getTransportDeviceMsgRateLimit() {
        return this.transportDeviceMsgRateLimit;
    }

    public String getTransportDeviceTelemetryMsgRateLimit() {
        return this.transportDeviceTelemetryMsgRateLimit;
    }

    public String getTransportDeviceTelemetryDataPointsRateLimit() {
        return this.transportDeviceTelemetryDataPointsRateLimit;
    }

    public long getMaxTransportMessages() {
        return this.maxTransportMessages;
    }

    public long getMaxTransportDataPoints() {
        return this.maxTransportDataPoints;
    }

    public long getMaxREExecutions() {
        return this.maxREExecutions;
    }

    public long getMaxJSExecutions() {
        return this.maxJSExecutions;
    }

    public long getMaxDPStorageDays() {
        return this.maxDPStorageDays;
    }

    public int getMaxRuleNodeExecutionsPerMessage() {
        return this.maxRuleNodeExecutionsPerMessage;
    }

    public long getMaxEmails() {
        return this.maxEmails;
    }

    public long getMaxSms() {
        return this.maxSms;
    }

    public long getMaxCreatedAlarms() {
        return this.maxCreatedAlarms;
    }

    public int getDefaultStorageTtlDays() {
        return this.defaultStorageTtlDays;
    }

    public int getAlarmsTtlDays() {
        return this.alarmsTtlDays;
    }

    public int getRpcTtlDays() {
        return this.rpcTtlDays;
    }

    public double getWarnThreshold() {
        return this.warnThreshold;
    }

    public void setMaxDevices(long maxDevices) {
        this.maxDevices = maxDevices;
    }

    public void setMaxAssets(long maxAssets) {
        this.maxAssets = maxAssets;
    }

    public void setMaxCustomers(long maxCustomers) {
        this.maxCustomers = maxCustomers;
    }

    public void setMaxUsers(long maxUsers) {
        this.maxUsers = maxUsers;
    }

    public void setMaxDashboards(long maxDashboards) {
        this.maxDashboards = maxDashboards;
    }

    public void setMaxRuleChains(long maxRuleChains) {
        this.maxRuleChains = maxRuleChains;
    }

    public void setMaxResourcesInBytes(long maxResourcesInBytes) {
        this.maxResourcesInBytes = maxResourcesInBytes;
    }

    public void setMaxOtaPackagesInBytes(long maxOtaPackagesInBytes) {
        this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
    }

    public void setMaxIntegrations(long maxIntegrations) {
        this.maxIntegrations = maxIntegrations;
    }

    public void setMaxConverters(long maxConverters) {
        this.maxConverters = maxConverters;
    }

    public void setMaxSchedulerEvents(long maxSchedulerEvents) {
        this.maxSchedulerEvents = maxSchedulerEvents;
    }

    public void setTransportTenantMsgRateLimit(String transportTenantMsgRateLimit) {
        this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
    }

    public void setTransportTenantTelemetryMsgRateLimit(String transportTenantTelemetryMsgRateLimit) {
        this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
    }

    public void setTransportTenantTelemetryDataPointsRateLimit(String transportTenantTelemetryDataPointsRateLimit) {
        this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
    }

    public void setTransportDeviceMsgRateLimit(String transportDeviceMsgRateLimit) {
        this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
    }

    public void setTransportDeviceTelemetryMsgRateLimit(String transportDeviceTelemetryMsgRateLimit) {
        this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
    }

    public void setTransportDeviceTelemetryDataPointsRateLimit(String transportDeviceTelemetryDataPointsRateLimit) {
        this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
    }

    public void setMaxTransportMessages(long maxTransportMessages) {
        this.maxTransportMessages = maxTransportMessages;
    }

    public void setMaxTransportDataPoints(long maxTransportDataPoints) {
        this.maxTransportDataPoints = maxTransportDataPoints;
    }

    public void setMaxREExecutions(long maxREExecutions) {
        this.maxREExecutions = maxREExecutions;
    }

    public void setMaxJSExecutions(long maxJSExecutions) {
        this.maxJSExecutions = maxJSExecutions;
    }

    public void setMaxDPStorageDays(long maxDPStorageDays) {
        this.maxDPStorageDays = maxDPStorageDays;
    }

    public void setMaxRuleNodeExecutionsPerMessage(int maxRuleNodeExecutionsPerMessage) {
        this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
    }

    public void setMaxEmails(long maxEmails) {
        this.maxEmails = maxEmails;
    }

    public void setMaxSms(long maxSms) {
        this.maxSms = maxSms;
    }

    public void setMaxCreatedAlarms(long maxCreatedAlarms) {
        this.maxCreatedAlarms = maxCreatedAlarms;
    }

    public void setDefaultStorageTtlDays(int defaultStorageTtlDays) {
        this.defaultStorageTtlDays = defaultStorageTtlDays;
    }

    public void setAlarmsTtlDays(int alarmsTtlDays) {
        this.alarmsTtlDays = alarmsTtlDays;
    }

    public void setRpcTtlDays(int rpcTtlDays) {
        this.rpcTtlDays = rpcTtlDays;
    }

    public void setWarnThreshold(double warnThreshold) {
        this.warnThreshold = warnThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTenantProfileConfiguration)) {
            return false;
        }
        DefaultTenantProfileConfiguration other = (DefaultTenantProfileConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxDevices() != other.getMaxDevices()) {
            return false;
        }
        if (this.getMaxAssets() != other.getMaxAssets()) {
            return false;
        }
        if (this.getMaxCustomers() != other.getMaxCustomers()) {
            return false;
        }
        if (this.getMaxUsers() != other.getMaxUsers()) {
            return false;
        }
        if (this.getMaxDashboards() != other.getMaxDashboards()) {
            return false;
        }
        if (this.getMaxRuleChains() != other.getMaxRuleChains()) {
            return false;
        }
        if (this.getMaxResourcesInBytes() != other.getMaxResourcesInBytes()) {
            return false;
        }
        if (this.getMaxOtaPackagesInBytes() != other.getMaxOtaPackagesInBytes()) {
            return false;
        }
        if (this.getMaxIntegrations() != other.getMaxIntegrations()) {
            return false;
        }
        if (this.getMaxConverters() != other.getMaxConverters()) {
            return false;
        }
        if (this.getMaxSchedulerEvents() != other.getMaxSchedulerEvents()) {
            return false;
        }
        if (this.getMaxTransportMessages() != other.getMaxTransportMessages()) {
            return false;
        }
        if (this.getMaxTransportDataPoints() != other.getMaxTransportDataPoints()) {
            return false;
        }
        if (this.getMaxREExecutions() != other.getMaxREExecutions()) {
            return false;
        }
        if (this.getMaxJSExecutions() != other.getMaxJSExecutions()) {
            return false;
        }
        if (this.getMaxDPStorageDays() != other.getMaxDPStorageDays()) {
            return false;
        }
        if (this.getMaxRuleNodeExecutionsPerMessage() != other.getMaxRuleNodeExecutionsPerMessage()) {
            return false;
        }
        if (this.getMaxEmails() != other.getMaxEmails()) {
            return false;
        }
        if (this.getMaxSms() != other.getMaxSms()) {
            return false;
        }
        if (this.getMaxCreatedAlarms() != other.getMaxCreatedAlarms()) {
            return false;
        }
        if (this.getDefaultStorageTtlDays() != other.getDefaultStorageTtlDays()) {
            return false;
        }
        if (this.getAlarmsTtlDays() != other.getAlarmsTtlDays()) {
            return false;
        }
        if (this.getRpcTtlDays() != other.getRpcTtlDays()) {
            return false;
        }
        if (Double.compare(this.getWarnThreshold(), other.getWarnThreshold()) != 0) {
            return false;
        }
        String this$transportTenantMsgRateLimit = this.getTransportTenantMsgRateLimit();
        String other$transportTenantMsgRateLimit = other.getTransportTenantMsgRateLimit();
        if (this$transportTenantMsgRateLimit == null ? other$transportTenantMsgRateLimit != null : !this$transportTenantMsgRateLimit.equals(other$transportTenantMsgRateLimit)) {
            return false;
        }
        String this$transportTenantTelemetryMsgRateLimit = this.getTransportTenantTelemetryMsgRateLimit();
        String other$transportTenantTelemetryMsgRateLimit = other.getTransportTenantTelemetryMsgRateLimit();
        if (this$transportTenantTelemetryMsgRateLimit == null ? other$transportTenantTelemetryMsgRateLimit != null : !this$transportTenantTelemetryMsgRateLimit.equals(other$transportTenantTelemetryMsgRateLimit)) {
            return false;
        }
        String this$transportTenantTelemetryDataPointsRateLimit = this.getTransportTenantTelemetryDataPointsRateLimit();
        String other$transportTenantTelemetryDataPointsRateLimit = other.getTransportTenantTelemetryDataPointsRateLimit();
        if (this$transportTenantTelemetryDataPointsRateLimit == null ? other$transportTenantTelemetryDataPointsRateLimit != null : !this$transportTenantTelemetryDataPointsRateLimit.equals(other$transportTenantTelemetryDataPointsRateLimit)) {
            return false;
        }
        String this$transportDeviceMsgRateLimit = this.getTransportDeviceMsgRateLimit();
        String other$transportDeviceMsgRateLimit = other.getTransportDeviceMsgRateLimit();
        if (this$transportDeviceMsgRateLimit == null ? other$transportDeviceMsgRateLimit != null : !this$transportDeviceMsgRateLimit.equals(other$transportDeviceMsgRateLimit)) {
            return false;
        }
        String this$transportDeviceTelemetryMsgRateLimit = this.getTransportDeviceTelemetryMsgRateLimit();
        String other$transportDeviceTelemetryMsgRateLimit = other.getTransportDeviceTelemetryMsgRateLimit();
        if (this$transportDeviceTelemetryMsgRateLimit == null ? other$transportDeviceTelemetryMsgRateLimit != null : !this$transportDeviceTelemetryMsgRateLimit.equals(other$transportDeviceTelemetryMsgRateLimit)) {
            return false;
        }
        String this$transportDeviceTelemetryDataPointsRateLimit = this.getTransportDeviceTelemetryDataPointsRateLimit();
        String other$transportDeviceTelemetryDataPointsRateLimit = other.getTransportDeviceTelemetryDataPointsRateLimit();
        return !(this$transportDeviceTelemetryDataPointsRateLimit == null ? other$transportDeviceTelemetryDataPointsRateLimit != null : !this$transportDeviceTelemetryDataPointsRateLimit.equals(other$transportDeviceTelemetryDataPointsRateLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultTenantProfileConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxDevices = this.getMaxDevices();
        result = result * 59 + (int)($maxDevices >>> 32 ^ $maxDevices);
        long $maxAssets = this.getMaxAssets();
        result = result * 59 + (int)($maxAssets >>> 32 ^ $maxAssets);
        long $maxCustomers = this.getMaxCustomers();
        result = result * 59 + (int)($maxCustomers >>> 32 ^ $maxCustomers);
        long $maxUsers = this.getMaxUsers();
        result = result * 59 + (int)($maxUsers >>> 32 ^ $maxUsers);
        long $maxDashboards = this.getMaxDashboards();
        result = result * 59 + (int)($maxDashboards >>> 32 ^ $maxDashboards);
        long $maxRuleChains = this.getMaxRuleChains();
        result = result * 59 + (int)($maxRuleChains >>> 32 ^ $maxRuleChains);
        long $maxResourcesInBytes = this.getMaxResourcesInBytes();
        result = result * 59 + (int)($maxResourcesInBytes >>> 32 ^ $maxResourcesInBytes);
        long $maxOtaPackagesInBytes = this.getMaxOtaPackagesInBytes();
        result = result * 59 + (int)($maxOtaPackagesInBytes >>> 32 ^ $maxOtaPackagesInBytes);
        long $maxIntegrations = this.getMaxIntegrations();
        result = result * 59 + (int)($maxIntegrations >>> 32 ^ $maxIntegrations);
        long $maxConverters = this.getMaxConverters();
        result = result * 59 + (int)($maxConverters >>> 32 ^ $maxConverters);
        long $maxSchedulerEvents = this.getMaxSchedulerEvents();
        result = result * 59 + (int)($maxSchedulerEvents >>> 32 ^ $maxSchedulerEvents);
        long $maxTransportMessages = this.getMaxTransportMessages();
        result = result * 59 + (int)($maxTransportMessages >>> 32 ^ $maxTransportMessages);
        long $maxTransportDataPoints = this.getMaxTransportDataPoints();
        result = result * 59 + (int)($maxTransportDataPoints >>> 32 ^ $maxTransportDataPoints);
        long $maxREExecutions = this.getMaxREExecutions();
        result = result * 59 + (int)($maxREExecutions >>> 32 ^ $maxREExecutions);
        long $maxJSExecutions = this.getMaxJSExecutions();
        result = result * 59 + (int)($maxJSExecutions >>> 32 ^ $maxJSExecutions);
        long $maxDPStorageDays = this.getMaxDPStorageDays();
        result = result * 59 + (int)($maxDPStorageDays >>> 32 ^ $maxDPStorageDays);
        result = result * 59 + this.getMaxRuleNodeExecutionsPerMessage();
        long $maxEmails = this.getMaxEmails();
        result = result * 59 + (int)($maxEmails >>> 32 ^ $maxEmails);
        long $maxSms = this.getMaxSms();
        result = result * 59 + (int)($maxSms >>> 32 ^ $maxSms);
        long $maxCreatedAlarms = this.getMaxCreatedAlarms();
        result = result * 59 + (int)($maxCreatedAlarms >>> 32 ^ $maxCreatedAlarms);
        result = result * 59 + this.getDefaultStorageTtlDays();
        result = result * 59 + this.getAlarmsTtlDays();
        result = result * 59 + this.getRpcTtlDays();
        long $warnThreshold = Double.doubleToLongBits(this.getWarnThreshold());
        result = result * 59 + (int)($warnThreshold >>> 32 ^ $warnThreshold);
        String $transportTenantMsgRateLimit = this.getTransportTenantMsgRateLimit();
        result = result * 59 + ($transportTenantMsgRateLimit == null ? 43 : $transportTenantMsgRateLimit.hashCode());
        String $transportTenantTelemetryMsgRateLimit = this.getTransportTenantTelemetryMsgRateLimit();
        result = result * 59 + ($transportTenantTelemetryMsgRateLimit == null ? 43 : $transportTenantTelemetryMsgRateLimit.hashCode());
        String $transportTenantTelemetryDataPointsRateLimit = this.getTransportTenantTelemetryDataPointsRateLimit();
        result = result * 59 + ($transportTenantTelemetryDataPointsRateLimit == null ? 43 : $transportTenantTelemetryDataPointsRateLimit.hashCode());
        String $transportDeviceMsgRateLimit = this.getTransportDeviceMsgRateLimit();
        result = result * 59 + ($transportDeviceMsgRateLimit == null ? 43 : $transportDeviceMsgRateLimit.hashCode());
        String $transportDeviceTelemetryMsgRateLimit = this.getTransportDeviceTelemetryMsgRateLimit();
        result = result * 59 + ($transportDeviceTelemetryMsgRateLimit == null ? 43 : $transportDeviceTelemetryMsgRateLimit.hashCode());
        String $transportDeviceTelemetryDataPointsRateLimit = this.getTransportDeviceTelemetryDataPointsRateLimit();
        result = result * 59 + ($transportDeviceTelemetryDataPointsRateLimit == null ? 43 : $transportDeviceTelemetryDataPointsRateLimit.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultTenantProfileConfiguration(maxDevices=" + this.getMaxDevices() + ", maxAssets=" + this.getMaxAssets() + ", maxCustomers=" + this.getMaxCustomers() + ", maxUsers=" + this.getMaxUsers() + ", maxDashboards=" + this.getMaxDashboards() + ", maxRuleChains=" + this.getMaxRuleChains() + ", maxResourcesInBytes=" + this.getMaxResourcesInBytes() + ", maxOtaPackagesInBytes=" + this.getMaxOtaPackagesInBytes() + ", maxIntegrations=" + this.getMaxIntegrations() + ", maxConverters=" + this.getMaxConverters() + ", maxSchedulerEvents=" + this.getMaxSchedulerEvents() + ", transportTenantMsgRateLimit=" + this.getTransportTenantMsgRateLimit() + ", transportTenantTelemetryMsgRateLimit=" + this.getTransportTenantTelemetryMsgRateLimit() + ", transportTenantTelemetryDataPointsRateLimit=" + this.getTransportTenantTelemetryDataPointsRateLimit() + ", transportDeviceMsgRateLimit=" + this.getTransportDeviceMsgRateLimit() + ", transportDeviceTelemetryMsgRateLimit=" + this.getTransportDeviceTelemetryMsgRateLimit() + ", transportDeviceTelemetryDataPointsRateLimit=" + this.getTransportDeviceTelemetryDataPointsRateLimit() + ", maxTransportMessages=" + this.getMaxTransportMessages() + ", maxTransportDataPoints=" + this.getMaxTransportDataPoints() + ", maxREExecutions=" + this.getMaxREExecutions() + ", maxJSExecutions=" + this.getMaxJSExecutions() + ", maxDPStorageDays=" + this.getMaxDPStorageDays() + ", maxRuleNodeExecutionsPerMessage=" + this.getMaxRuleNodeExecutionsPerMessage() + ", maxEmails=" + this.getMaxEmails() + ", maxSms=" + this.getMaxSms() + ", maxCreatedAlarms=" + this.getMaxCreatedAlarms() + ", defaultStorageTtlDays=" + this.getDefaultStorageTtlDays() + ", alarmsTtlDays=" + this.getAlarmsTtlDays() + ", rpcTtlDays=" + this.getRpcTtlDays() + ", warnThreshold=" + this.getWarnThreshold() + ")";
    }

    public static class DefaultTenantProfileConfigurationBuilder {
        private long maxDevices;
        private long maxAssets;
        private long maxCustomers;
        private long maxUsers;
        private long maxDashboards;
        private long maxRuleChains;
        private long maxResourcesInBytes;
        private long maxOtaPackagesInBytes;
        private long maxIntegrations;
        private long maxConverters;
        private long maxSchedulerEvents;
        private String transportTenantMsgRateLimit;
        private String transportTenantTelemetryMsgRateLimit;
        private String transportTenantTelemetryDataPointsRateLimit;
        private String transportDeviceMsgRateLimit;
        private String transportDeviceTelemetryMsgRateLimit;
        private String transportDeviceTelemetryDataPointsRateLimit;
        private long maxTransportMessages;
        private long maxTransportDataPoints;
        private long maxREExecutions;
        private long maxJSExecutions;
        private long maxDPStorageDays;
        private int maxRuleNodeExecutionsPerMessage;
        private long maxEmails;
        private long maxSms;
        private long maxCreatedAlarms;
        private int defaultStorageTtlDays;
        private int alarmsTtlDays;
        private int rpcTtlDays;
        private double warnThreshold;

        DefaultTenantProfileConfigurationBuilder() {
        }

        public DefaultTenantProfileConfigurationBuilder maxDevices(long maxDevices) {
            this.maxDevices = maxDevices;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxAssets(long maxAssets) {
            this.maxAssets = maxAssets;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxCustomers(long maxCustomers) {
            this.maxCustomers = maxCustomers;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxUsers(long maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxDashboards(long maxDashboards) {
            this.maxDashboards = maxDashboards;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxRuleChains(long maxRuleChains) {
            this.maxRuleChains = maxRuleChains;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxResourcesInBytes(long maxResourcesInBytes) {
            this.maxResourcesInBytes = maxResourcesInBytes;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxOtaPackagesInBytes(long maxOtaPackagesInBytes) {
            this.maxOtaPackagesInBytes = maxOtaPackagesInBytes;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxIntegrations(long maxIntegrations) {
            this.maxIntegrations = maxIntegrations;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxConverters(long maxConverters) {
            this.maxConverters = maxConverters;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxSchedulerEvents(long maxSchedulerEvents) {
            this.maxSchedulerEvents = maxSchedulerEvents;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportTenantMsgRateLimit(String transportTenantMsgRateLimit) {
            this.transportTenantMsgRateLimit = transportTenantMsgRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportTenantTelemetryMsgRateLimit(String transportTenantTelemetryMsgRateLimit) {
            this.transportTenantTelemetryMsgRateLimit = transportTenantTelemetryMsgRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportTenantTelemetryDataPointsRateLimit(String transportTenantTelemetryDataPointsRateLimit) {
            this.transportTenantTelemetryDataPointsRateLimit = transportTenantTelemetryDataPointsRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportDeviceMsgRateLimit(String transportDeviceMsgRateLimit) {
            this.transportDeviceMsgRateLimit = transportDeviceMsgRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportDeviceTelemetryMsgRateLimit(String transportDeviceTelemetryMsgRateLimit) {
            this.transportDeviceTelemetryMsgRateLimit = transportDeviceTelemetryMsgRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder transportDeviceTelemetryDataPointsRateLimit(String transportDeviceTelemetryDataPointsRateLimit) {
            this.transportDeviceTelemetryDataPointsRateLimit = transportDeviceTelemetryDataPointsRateLimit;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxTransportMessages(long maxTransportMessages) {
            this.maxTransportMessages = maxTransportMessages;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxTransportDataPoints(long maxTransportDataPoints) {
            this.maxTransportDataPoints = maxTransportDataPoints;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxREExecutions(long maxREExecutions) {
            this.maxREExecutions = maxREExecutions;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxJSExecutions(long maxJSExecutions) {
            this.maxJSExecutions = maxJSExecutions;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxDPStorageDays(long maxDPStorageDays) {
            this.maxDPStorageDays = maxDPStorageDays;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxRuleNodeExecutionsPerMessage(int maxRuleNodeExecutionsPerMessage) {
            this.maxRuleNodeExecutionsPerMessage = maxRuleNodeExecutionsPerMessage;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxEmails(long maxEmails) {
            this.maxEmails = maxEmails;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxSms(long maxSms) {
            this.maxSms = maxSms;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder maxCreatedAlarms(long maxCreatedAlarms) {
            this.maxCreatedAlarms = maxCreatedAlarms;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder defaultStorageTtlDays(int defaultStorageTtlDays) {
            this.defaultStorageTtlDays = defaultStorageTtlDays;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder alarmsTtlDays(int alarmsTtlDays) {
            this.alarmsTtlDays = alarmsTtlDays;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder rpcTtlDays(int rpcTtlDays) {
            this.rpcTtlDays = rpcTtlDays;
            return this;
        }

        public DefaultTenantProfileConfigurationBuilder warnThreshold(double warnThreshold) {
            this.warnThreshold = warnThreshold;
            return this;
        }

        public DefaultTenantProfileConfiguration build() {
            return new DefaultTenantProfileConfiguration(this.maxDevices, this.maxAssets, this.maxCustomers, this.maxUsers, this.maxDashboards, this.maxRuleChains, this.maxResourcesInBytes, this.maxOtaPackagesInBytes, this.maxIntegrations, this.maxConverters, this.maxSchedulerEvents, this.transportTenantMsgRateLimit, this.transportTenantTelemetryMsgRateLimit, this.transportTenantTelemetryDataPointsRateLimit, this.transportDeviceMsgRateLimit, this.transportDeviceTelemetryMsgRateLimit, this.transportDeviceTelemetryDataPointsRateLimit, this.maxTransportMessages, this.maxTransportDataPoints, this.maxREExecutions, this.maxJSExecutions, this.maxDPStorageDays, this.maxRuleNodeExecutionsPerMessage, this.maxEmails, this.maxSms, this.maxCreatedAlarms, this.defaultStorageTtlDays, this.alarmsTtlDays, this.rpcTtlDays, this.warnThreshold);
        }

        public String toString() {
            return "DefaultTenantProfileConfiguration.DefaultTenantProfileConfigurationBuilder(maxDevices=" + this.maxDevices + ", maxAssets=" + this.maxAssets + ", maxCustomers=" + this.maxCustomers + ", maxUsers=" + this.maxUsers + ", maxDashboards=" + this.maxDashboards + ", maxRuleChains=" + this.maxRuleChains + ", maxResourcesInBytes=" + this.maxResourcesInBytes + ", maxOtaPackagesInBytes=" + this.maxOtaPackagesInBytes + ", maxIntegrations=" + this.maxIntegrations + ", maxConverters=" + this.maxConverters + ", maxSchedulerEvents=" + this.maxSchedulerEvents + ", transportTenantMsgRateLimit=" + this.transportTenantMsgRateLimit + ", transportTenantTelemetryMsgRateLimit=" + this.transportTenantTelemetryMsgRateLimit + ", transportTenantTelemetryDataPointsRateLimit=" + this.transportTenantTelemetryDataPointsRateLimit + ", transportDeviceMsgRateLimit=" + this.transportDeviceMsgRateLimit + ", transportDeviceTelemetryMsgRateLimit=" + this.transportDeviceTelemetryMsgRateLimit + ", transportDeviceTelemetryDataPointsRateLimit=" + this.transportDeviceTelemetryDataPointsRateLimit + ", maxTransportMessages=" + this.maxTransportMessages + ", maxTransportDataPoints=" + this.maxTransportDataPoints + ", maxREExecutions=" + this.maxREExecutions + ", maxJSExecutions=" + this.maxJSExecutions + ", maxDPStorageDays=" + this.maxDPStorageDays + ", maxRuleNodeExecutionsPerMessage=" + this.maxRuleNodeExecutionsPerMessage + ", maxEmails=" + this.maxEmails + ", maxSms=" + this.maxSms + ", maxCreatedAlarms=" + this.maxCreatedAlarms + ", defaultStorageTtlDays=" + this.defaultStorageTtlDays + ", alarmsTtlDays=" + this.alarmsTtlDays + ", rpcTtlDays=" + this.rpcTtlDays + ", warnThreshold=" + this.warnThreshold + ")";
        }
    }
}

