/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.role;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.common.data.validation.NoXss;

public class Role
extends SearchTextBasedWithAdditionalInfo<RoleId>
implements HasName,
TenantEntity,
HasCustomerId,
HasOwnerId {
    private static final long serialVersionUID = 5582010124562018986L;
    public static final String ROLE_TENANT_ADMIN_NAME = "Tenant Administrator";
    public static final String ROLE_TENANT_USER_NAME = "Tenant User";
    public static final String ROLE_CUSTOMER_ADMIN_NAME = "Customer Administrator";
    public static final String ROLE_CUSTOMER_USER_NAME = "Customer User";
    public static final String ROLE_PUBLIC_USER_NAME = "Public User";
    public static final String ROLE_PUBLIC_USER_ENTITY_GROUP_NAME = "Entity Group Public User";
    public static final String ROLE_READ_ONLY_ENTITY_GROUP_NAME = "Entity Group Read-only User";
    public static final String ROLE_WRITE_ENTITY_GROUP_NAME = "Entity Group Write User";
    private TenantId tenantId;
    private CustomerId customerId;
    @NoXss
    private String name;
    private RoleType type;
    private transient JsonNode permissions;
    @JsonIgnore
    private byte[] permissionsBytes;

    public Role() {
    }

    public Role(RoleId id) {
        super(id);
    }

    public Role(Role role) {
        super(role);
        this.setPermissions(role.getPermissions());
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.ROLE;
    }

    public JsonNode getPermissions() {
        return Role.getJson(() -> this.permissions, () -> this.permissionsBytes);
    }

    public void setPermissions(JsonNode permissions) {
        Role.setJson(permissions, json -> {
            this.permissions = json;
        }, bytes -> {
            this.permissionsBytes = bytes;
        });
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public RoleType getType() {
        return this.type;
    }

    public byte[] getPermissionsBytes() {
        return this.permissionsBytes;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(RoleType type) {
        this.type = type;
    }

    @JsonIgnore
    public void setPermissionsBytes(byte[] permissionsBytes) {
        this.permissionsBytes = permissionsBytes;
    }

    @Override
    public String toString() {
        return "Role(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", name=" + this.getName() + ", type=" + this.getType() + ", permissions=" + this.getPermissions() + ", permissionsBytes=" + Arrays.toString(this.getPermissionsBytes()) + ")";
    }

    @ConstructorProperties(value={"tenantId", "customerId", "name", "type", "permissions", "permissionsBytes"})
    public Role(TenantId tenantId, CustomerId customerId, String name, RoleType type, JsonNode permissions, byte[] permissionsBytes) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.type = type;
        this.permissions = permissions;
        this.permissionsBytes = permissionsBytes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role other = (Role)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        RoleType this$type = this.getType();
        RoleType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return Arrays.equals(this.getPermissionsBytes(), other.getPermissionsBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Role;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        RoleType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPermissionsBytes());
        return result;
    }
}

