/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.security.Authority;

public enum Resource {
    ALL,
    PROFILE,
    ADMIN_SETTINGS,
    ALARM(EntityType.ALARM),
    DEVICE(EntityType.DEVICE),
    ASSET(EntityType.ASSET),
    CUSTOMER(EntityType.CUSTOMER),
    DASHBOARD(EntityType.DASHBOARD),
    ENTITY_VIEW(EntityType.ENTITY_VIEW),
    EDGE(EntityType.EDGE),
    TENANT(EntityType.TENANT),
    RULE_CHAIN(EntityType.RULE_CHAIN),
    USER(EntityType.USER),
    WIDGETS_BUNDLE(EntityType.WIDGETS_BUNDLE),
    WIDGET_TYPE(EntityType.WIDGET_TYPE),
    OAUTH2_CONFIGURATION_INFO,
    OAUTH2_CONFIGURATION_TEMPLATE,
    TENANT_PROFILE(EntityType.TENANT_PROFILE),
    DEVICE_PROFILE(EntityType.DEVICE_PROFILE),
    CONVERTER(EntityType.CONVERTER),
    INTEGRATION(EntityType.INTEGRATION),
    SCHEDULER_EVENT(EntityType.SCHEDULER_EVENT),
    BLOB_ENTITY(EntityType.BLOB_ENTITY),
    CUSTOMER_GROUP(EntityType.ENTITY_GROUP),
    DEVICE_GROUP(EntityType.ENTITY_GROUP),
    ASSET_GROUP(EntityType.ENTITY_GROUP),
    USER_GROUP(EntityType.ENTITY_GROUP),
    ENTITY_VIEW_GROUP(EntityType.ENTITY_GROUP),
    EDGE_GROUP(EntityType.ENTITY_GROUP),
    DASHBOARD_GROUP(EntityType.ENTITY_GROUP),
    ROLE(EntityType.ROLE),
    GROUP_PERMISSION(EntityType.GROUP_PERMISSION),
    WHITE_LABELING,
    AUDIT_LOG,
    API_USAGE_STATE(EntityType.API_USAGE_STATE),
    TB_RESOURCE(EntityType.TB_RESOURCE),
    OTA_PACKAGE(EntityType.OTA_PACKAGE);

    private static final Map<EntityType, Resource> groupResourceByGroupType;
    private static final Map<EntityType, Resource> resourceByEntityType;
    public static final Map<Resource, Set<Operation>> operationsByResource;
    public static final Map<Authority, Set<Resource>> resourcesByAuthority;
    private final EntityType entityType;

    public static Resource groupResourceFromGroupType(EntityType groupType) {
        return groupResourceByGroupType.get((Object)groupType);
    }

    public static Resource resourceFromEntityType(EntityType entityType) {
        return resourceByEntityType.get((Object)entityType);
    }

    public static Set<Operation> operationsForResource(Resource resource) {
        return operationsByResource.get((Object)resource);
    }

    private Resource() {
        this.entityType = null;
    }

    private Resource(EntityType entityType) {
        this.entityType = entityType;
    }

    public Optional<EntityType> getEntityType() {
        return Optional.ofNullable(this.entityType);
    }

    static {
        groupResourceByGroupType = new HashMap<EntityType, Resource>();
        resourceByEntityType = new HashMap<EntityType, Resource>();
        operationsByResource = new HashMap<Resource, Set<Operation>>();
        resourcesByAuthority = new HashMap<Authority, Set<Resource>>();
        groupResourceByGroupType.put(EntityType.CUSTOMER, CUSTOMER_GROUP);
        groupResourceByGroupType.put(EntityType.DEVICE, DEVICE_GROUP);
        groupResourceByGroupType.put(EntityType.ASSET, ASSET_GROUP);
        groupResourceByGroupType.put(EntityType.USER, USER_GROUP);
        groupResourceByGroupType.put(EntityType.ENTITY_VIEW, ENTITY_VIEW_GROUP);
        groupResourceByGroupType.put(EntityType.EDGE, EDGE_GROUP);
        groupResourceByGroupType.put(EntityType.DASHBOARD, DASHBOARD_GROUP);
        for (EntityType entityType : EntityType.values()) {
            if (entityType.equals((Object)EntityType.ENTITY_GROUP)) continue;
            for (Resource resource : Resource.values()) {
                if (!resource.getEntityType().isPresent() || !resource.getEntityType().get().equals((Object)entityType)) continue;
                resourceByEntityType.put(entityType, resource);
            }
        }
        operationsByResource.put(ALL, new HashSet<Operation>(Arrays.asList(Operation.values())));
        operationsByResource.put(PROFILE, new HashSet<Operation>(Arrays.asList(Operation.ALL, Operation.WRITE)));
        operationsByResource.put(ADMIN_SETTINGS, new HashSet<Operation>(Arrays.asList(Operation.ALL, Operation.READ, Operation.WRITE)));
        operationsByResource.put(OAUTH2_CONFIGURATION_INFO, Operation.crudOperations);
        operationsByResource.put(OAUTH2_CONFIGURATION_TEMPLATE, Operation.crudOperations);
        operationsByResource.put(ALARM, new HashSet<Operation>(Arrays.asList(Operation.ALL, Operation.READ, Operation.WRITE, Operation.CREATE)));
        operationsByResource.put(DEVICE, new HashSet<Operation>(Arrays.asList(Operation.ALL, Operation.READ, Operation.WRITE, Operation.CREATE, Operation.DELETE, Operation.RPC_CALL, Operation.READ_CREDENTIALS, Operation.WRITE_CREDENTIALS, Operation.READ_ATTRIBUTES, Operation.WRITE_ATTRIBUTES, Operation.READ_TELEMETRY, Operation.WRITE_TELEMETRY, Operation.CLAIM_DEVICES, Operation.CHANGE_OWNER, Operation.ASSIGN_TO_TENANT)));
        operationsByResource.put(DEVICE_PROFILE, Operation.defaultEntityOperations);
        operationsByResource.put(OTA_PACKAGE, Operation.defaultEntityOperations);
        operationsByResource.put(ASSET, Operation.defaultEntityOperations);
        operationsByResource.put(CUSTOMER, Operation.defaultEntityOperations);
        operationsByResource.put(DASHBOARD, Operation.defaultEntityOperations);
        operationsByResource.put(ENTITY_VIEW, Operation.defaultEntityOperations);
        operationsByResource.put(EDGE, Operation.defaultEntityOperations);
        operationsByResource.put(TENANT, Operation.defaultEntityOperations);
        operationsByResource.put(TENANT_PROFILE, Operation.defaultEntityOperations);
        operationsByResource.put(API_USAGE_STATE, new HashSet<Operation>(Arrays.asList(Operation.ALL, Operation.READ, Operation.READ_TELEMETRY)));
        operationsByResource.put(RULE_CHAIN, Operation.defaultEntityOperations);
        HashSet<Operation> userOperations = new HashSet<Operation>(Operation.defaultEntityOperations);
        userOperations.add(Operation.IMPERSONATE);
        operationsByResource.put(USER, userOperations);
        operationsByResource.put(WIDGETS_BUNDLE, Operation.crudOperations);
        operationsByResource.put(WIDGET_TYPE, Operation.crudOperations);
        operationsByResource.put(TB_RESOURCE, Operation.defaultEntityOperations);
        operationsByResource.put(CONVERTER, Operation.defaultEntityOperations);
        operationsByResource.put(INTEGRATION, Operation.defaultEntityOperations);
        operationsByResource.put(SCHEDULER_EVENT, Operation.defaultEntityOperations);
        operationsByResource.put(BLOB_ENTITY, Operation.defaultEntityOperations);
        operationsByResource.put(CUSTOMER_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(DEVICE_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(ASSET_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(USER_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(ENTITY_VIEW_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(EDGE_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(DASHBOARD_GROUP, Operation.defaultEntityGroupOperations);
        operationsByResource.put(ROLE, Operation.defaultEntityOperations);
        operationsByResource.put(GROUP_PERMISSION, Operation.crudOperations);
        operationsByResource.put(WHITE_LABELING, new HashSet<Operation>(Arrays.asList(Operation.ALL, Operation.READ, Operation.WRITE)));
        operationsByResource.put(AUDIT_LOG, new HashSet<Operation>(Arrays.asList(Operation.ALL, Operation.READ)));
        resourcesByAuthority.put(Authority.SYS_ADMIN, new HashSet<Resource>(Arrays.asList(ALL, PROFILE, ADMIN_SETTINGS, DASHBOARD, ALARM, TENANT, TENANT_PROFILE, USER, WIDGETS_BUNDLE, WIDGET_TYPE, ROLE, WHITE_LABELING, OAUTH2_CONFIGURATION_INFO, OAUTH2_CONFIGURATION_TEMPLATE, TB_RESOURCE)));
        resourcesByAuthority.put(Authority.TENANT_ADMIN, new HashSet<Resource>(Arrays.asList(ALL, PROFILE, ALARM, DEVICE, DEVICE_PROFILE, API_USAGE_STATE, ASSET, ENTITY_VIEW, EDGE, CUSTOMER, DASHBOARD, TENANT, USER, WIDGETS_BUNDLE, WIDGET_TYPE, RULE_CHAIN, ROLE, CONVERTER, INTEGRATION, SCHEDULER_EVENT, BLOB_ENTITY, CUSTOMER_GROUP, USER_GROUP, DEVICE_GROUP, ASSET_GROUP, DASHBOARD_GROUP, ENTITY_VIEW_GROUP, EDGE_GROUP, GROUP_PERMISSION, WHITE_LABELING, AUDIT_LOG, TB_RESOURCE, OTA_PACKAGE)));
        resourcesByAuthority.put(Authority.CUSTOMER_USER, new HashSet<Resource>(Arrays.asList(ALL, PROFILE, ALARM, DEVICE, ASSET, ENTITY_VIEW, EDGE, CUSTOMER, DASHBOARD, USER, WIDGETS_BUNDLE, WIDGET_TYPE, ROLE, SCHEDULER_EVENT, BLOB_ENTITY, CUSTOMER_GROUP, USER_GROUP, DEVICE_GROUP, ASSET_GROUP, DASHBOARD_GROUP, ENTITY_VIEW_GROUP, EDGE_GROUP, GROUP_PERMISSION, WHITE_LABELING, AUDIT_LOG)));
    }
}

