/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.permission.MergedGroupPermissionInfo;
import org.thingsboard.server.common.data.permission.MergedGroupTypePermissionInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;

public final class MergedUserPermissions {
    private final Map<Resource, Set<Operation>> genericPermissions;
    private final Map<EntityGroupId, MergedGroupPermissionInfo> groupPermissions;
    private final Map<EntityType, MergedGroupTypePermissionInfo> readGroupPermissions;
    private final Map<Resource, MergedGroupTypePermissionInfo> readEntityPermissions;
    private final Map<Resource, MergedGroupTypePermissionInfo> readAttrPermissions;
    private final Map<Resource, MergedGroupTypePermissionInfo> readTsPermissions;

    public MergedUserPermissions(Map<Resource, Set<Operation>> genericPermissions, Map<EntityGroupId, MergedGroupPermissionInfo> groupPermissions) {
        boolean hasGenericRead;
        Resource resource;
        this.genericPermissions = genericPermissions;
        this.groupPermissions = groupPermissions;
        this.readGroupPermissions = new HashMap<EntityType, MergedGroupTypePermissionInfo>();
        this.readEntityPermissions = new HashMap<Resource, MergedGroupTypePermissionInfo>();
        this.readAttrPermissions = new HashMap<Resource, MergedGroupTypePermissionInfo>();
        this.readTsPermissions = new HashMap<Resource, MergedGroupTypePermissionInfo>();
        for (EntityType groupType : EntityGroup.groupTypes) {
            resource = Resource.groupResourceFromGroupType(groupType);
            hasGenericRead = this.hasGenericPermission(resource, Operation.READ);
            this.readGroupPermissions.put(groupType, new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(), hasGenericRead));
            this.readEntityPermissions.put(resource, new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(), hasGenericRead));
            boolean hasGenericAttrRead = this.hasGenericPermission(resource, Operation.READ_ATTRIBUTES);
            this.readAttrPermissions.put(resource, new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(), hasGenericAttrRead));
            boolean hasGenericTsRead = this.hasGenericPermission(resource, Operation.READ_TELEMETRY);
            this.readTsPermissions.put(resource, new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(), hasGenericTsRead));
        }
        for (EntityType entityType : EntityType.values()) {
            resource = Resource.resourceFromEntityType(entityType);
            if (resource == null) continue;
            hasGenericRead = this.hasGenericPermission(resource, Operation.READ);
            this.readEntityPermissions.put(resource, new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(), hasGenericRead));
            boolean hasGenericReadAttributes = this.hasGenericPermission(resource, Operation.READ_ATTRIBUTES);
            this.readAttrPermissions.put(resource, new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(), hasGenericReadAttributes));
            boolean hasGenericReadTelemetry = this.hasGenericPermission(resource, Operation.READ_TELEMETRY);
            this.readTsPermissions.put(resource, new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(), hasGenericReadTelemetry));
        }
        this.groupPermissions.forEach((id, info) -> {
            Resource groupResource;
            Resource entityResource;
            if (this.checkOperation(info.getOperations(), Operation.READ)) {
                this.readGroupPermissions.get((Object)info.getEntityType()).getEntityGroupIds().add((EntityGroupId)id);
                entityResource = Resource.resourceFromEntityType(info.getEntityType());
                this.readEntityPermissions.get((Object)entityResource).getEntityGroupIds().add((EntityGroupId)id);
                groupResource = Resource.groupResourceFromGroupType(info.getEntityType());
                if (groupResource != null) {
                    this.readEntityPermissions.get((Object)groupResource).getEntityGroupIds().add((EntityGroupId)id);
                }
            }
            if (this.checkOperation(info.getOperations(), Operation.READ_ATTRIBUTES)) {
                entityResource = Resource.resourceFromEntityType(info.getEntityType());
                this.readAttrPermissions.get((Object)entityResource).getEntityGroupIds().add((EntityGroupId)id);
                groupResource = Resource.groupResourceFromGroupType(info.getEntityType());
                if (groupResource != null) {
                    this.readAttrPermissions.get((Object)groupResource).getEntityGroupIds().add((EntityGroupId)id);
                }
            }
            if (this.checkOperation(info.getOperations(), Operation.READ_TELEMETRY)) {
                entityResource = Resource.resourceFromEntityType(info.getEntityType());
                this.readTsPermissions.get((Object)entityResource).getEntityGroupIds().add((EntityGroupId)id);
                groupResource = Resource.groupResourceFromGroupType(info.getEntityType());
                if (groupResource != null) {
                    this.readTsPermissions.get((Object)groupResource).getEntityGroupIds().add((EntityGroupId)id);
                }
            }
        });
    }

    public MergedGroupTypePermissionInfo getGroupPermissionsByEntityTypeAndOperation(EntityType entityType, Operation operation) {
        Resource resource = Resource.resourceFromEntityType(entityType);
        boolean hasGenericPermission = this.hasGenericPermission(resource, operation);
        List<EntityGroupId> groupIds = this.groupPermissions.entrySet().stream().filter(entry -> ((MergedGroupPermissionInfo)entry.getValue()).getEntityType().equals((Object)entityType) && this.checkOperation(((MergedGroupPermissionInfo)entry.getValue()).getOperations(), operation)).map(Map.Entry::getKey).collect(Collectors.toList());
        return new MergedGroupTypePermissionInfo(groupIds, hasGenericPermission);
    }

    public boolean hasGenericPermission(Resource resource, Operation operation) {
        return this.hasGenericResourcePermission(resource, operation) || this.hasGenericAllPermission(operation);
    }

    private boolean hasGenericAllPermission(Operation operation) {
        Set<Operation> operations = this.genericPermissions.get((Object)Resource.ALL);
        return operations != null && this.checkOperation(operations, operation);
    }

    private boolean hasGenericResourcePermission(Resource resource, Operation operation) {
        Set<Operation> operations = this.genericPermissions.get((Object)resource);
        return operations != null && this.checkOperation(operations, operation);
    }

    private boolean checkOperation(Set<Operation> operations, Operation operation) {
        return operations.contains((Object)Operation.ALL) || operations.contains((Object)operation);
    }

    public boolean hasGroupPermissions(EntityGroupId entityGroupId, Operation operation) {
        MergedGroupPermissionInfo permissionInfo = this.groupPermissions.get(entityGroupId);
        return permissionInfo != null && this.checkOperation(permissionInfo.getOperations(), operation);
    }

    public Map<Resource, Set<Operation>> getGenericPermissions() {
        return this.genericPermissions;
    }

    public Map<EntityGroupId, MergedGroupPermissionInfo> getGroupPermissions() {
        return this.groupPermissions;
    }

    public Map<EntityType, MergedGroupTypePermissionInfo> getReadGroupPermissions() {
        return this.readGroupPermissions;
    }

    public Map<Resource, MergedGroupTypePermissionInfo> getReadEntityPermissions() {
        return this.readEntityPermissions;
    }

    public Map<Resource, MergedGroupTypePermissionInfo> getReadAttrPermissions() {
        return this.readAttrPermissions;
    }

    public Map<Resource, MergedGroupTypePermissionInfo> getReadTsPermissions() {
        return this.readTsPermissions;
    }
}

