/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.group;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.group.ConfigurationDeserializer;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.validation.NoXss;

public class EntityGroup
extends BaseData<EntityGroupId>
implements HasName,
HasOwnerId {
    private static final long serialVersionUID = 2807349040519543363L;
    public static final EntityType[] groupTypes = new EntityType[]{EntityType.USER, EntityType.CUSTOMER, EntityType.DEVICE, EntityType.ASSET, EntityType.ENTITY_VIEW, EntityType.EDGE, EntityType.DASHBOARD};
    public static final EntityType[] sharableGroupTypes = new EntityType[]{EntityType.CUSTOMER, EntityType.DEVICE, EntityType.ASSET, EntityType.ENTITY_VIEW, EntityType.DASHBOARD, EntityType.EDGE};
    public static final String GROUP_ALL_NAME = "All";
    public static final String GROUP_TENANT_USERS_NAME = "Tenant Users";
    public static final String GROUP_TENANT_ADMINS_NAME = "Tenant Administrators";
    public static final String GROUP_CUSTOMER_USERS_NAME = "Customer Users";
    public static final String GROUP_CUSTOMER_ADMINS_NAME = "Customer Administrators";
    public static final String GROUP_PUBLIC_USERS_NAME = "Public Users";
    private static final String GROUP_EDGE_ALL_STARTS_WITH = "[Edge]";
    private static final String GROUP_EDGE_ALL_ENDS_WITH = "All";
    public static final String GROUP_EDGE_ALL_NAME_PATTERN = "[Edge] %s All";
    @ApiModelProperty(required=true, allowableValues="CUSTOMER,ASSET,DEVICE,USER,ENTITY_VIEW,DASHBOARD,EDGE")
    private EntityType type;
    @ApiModelProperty(required=true)
    @NoXss
    private String name;
    private EntityId ownerId;
    @JsonDeserialize(using=ConfigurationDeserializer.class)
    private JsonNode additionalInfo;
    @JsonDeserialize(using=ConfigurationDeserializer.class)
    private JsonNode configuration;

    public EntityGroup(EntityGroupId id) {
        super(id);
    }

    public EntityGroup(EntityGroup entityGroup) {
        super(entityGroup);
        this.type = entityGroup.getType();
        this.name = entityGroup.getName();
        this.ownerId = entityGroup.getOwnerId();
        this.additionalInfo = entityGroup.getAdditionalInfo();
        this.configuration = entityGroup.getConfiguration();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    public EntityId getOwnerId() {
        return this.ownerId;
    }

    public boolean isGroupAll() {
        return "All".equals(this.name);
    }

    public boolean isEdgeGroupAll() {
        return this.name.startsWith(GROUP_EDGE_ALL_STARTS_WITH) && this.name.endsWith("All");
    }

    @JsonIgnore
    public boolean isPublic() {
        if (this.getAdditionalInfo() != null && this.getAdditionalInfo().has("isPublic")) {
            return this.getAdditionalInfo().get("isPublic").asBoolean();
        }
        return false;
    }

    public EntityType getType() {
        return this.type;
    }

    public JsonNode getAdditionalInfo() {
        return this.additionalInfo;
    }

    public JsonNode getConfiguration() {
        return this.configuration;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOwnerId(EntityId ownerId) {
        this.ownerId = ownerId;
    }

    @JsonDeserialize(using=ConfigurationDeserializer.class)
    public void setAdditionalInfo(JsonNode additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @JsonDeserialize(using=ConfigurationDeserializer.class)
    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityGroup)) {
            return false;
        }
        EntityGroup other = (EntityGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EntityId this$ownerId = this.getOwnerId();
        EntityId other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        JsonNode this$additionalInfo = this.getAdditionalInfo();
        JsonNode other$additionalInfo = other.getAdditionalInfo();
        if (this$additionalInfo == null ? other$additionalInfo != null : !this$additionalInfo.equals(other$additionalInfo)) {
            return false;
        }
        JsonNode this$configuration = this.getConfiguration();
        JsonNode other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityGroup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EntityId $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        JsonNode $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : $additionalInfo.hashCode());
        JsonNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EntityGroup(type=" + this.getType() + ", name=" + this.getName() + ", ownerId=" + this.getOwnerId() + ", additionalInfo=" + this.getAdditionalInfo() + ", configuration=" + this.getConfiguration() + ")";
    }

    public EntityGroup() {
    }
}

