/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.entityview;

import java.util.Collections;
import java.util.List;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.RelationEntityTypeFilter;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;

public class EntityViewSearchQuery {
    private RelationsSearchParameters parameters;
    private String relationType;
    private List<String> entityViewTypes;

    public EntityRelationsQuery toEntitySearchQuery() {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(this.parameters);
        query.setFilters(Collections.singletonList(new RelationEntityTypeFilter(this.relationType == null ? "Contains" : this.relationType, Collections.singletonList(EntityType.ENTITY_VIEW))));
        return query;
    }

    public RelationsSearchParameters getParameters() {
        return this.parameters;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public List<String> getEntityViewTypes() {
        return this.entityViewTypes;
    }

    public void setParameters(RelationsSearchParameters parameters) {
        this.parameters = parameters;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public void setEntityViewTypes(List<String> entityViewTypes) {
        this.entityViewTypes = entityViewTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityViewSearchQuery)) {
            return false;
        }
        EntityViewSearchQuery other = (EntityViewSearchQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationsSearchParameters this$parameters = this.getParameters();
        RelationsSearchParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        List<String> this$entityViewTypes = this.getEntityViewTypes();
        List<String> other$entityViewTypes = other.getEntityViewTypes();
        return !(this$entityViewTypes == null ? other$entityViewTypes != null : !((Object)this$entityViewTypes).equals(other$entityViewTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityViewSearchQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationsSearchParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        List<String> $entityViewTypes = this.getEntityViewTypes();
        result = result * 59 + ($entityViewTypes == null ? 43 : ((Object)$entityViewTypes).hashCode());
        return result;
    }

    public String toString() {
        return "EntityViewSearchQuery(parameters=" + this.getParameters() + ", relationType=" + this.getRelationType() + ", entityViewTypes=" + this.getEntityViewTypes() + ")";
    }
}

