/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edge;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;

public class Edge
extends SearchTextBasedWithAdditionalInfo<EdgeId>
implements GroupEntity<EdgeId> {
    private static final long serialVersionUID = 4934987555236873728L;
    private TenantId tenantId;
    private CustomerId customerId;
    private RuleChainId rootRuleChainId;
    private String name;
    private String type;
    private String label;
    private String routingKey;
    private String secret;
    private String edgeLicenseKey;
    private String cloudEndpoint;

    public Edge() {
    }

    public Edge(EdgeId id) {
        super(id);
    }

    public Edge(Edge edge) {
        super(edge);
        this.tenantId = edge.getTenantId();
        this.customerId = edge.getCustomerId();
        this.type = edge.getType();
        this.name = edge.getName();
        this.routingKey = edge.getRoutingKey();
        this.secret = edge.getSecret();
        this.edgeLicenseKey = edge.getEdgeLicenseKey();
        this.cloudEndpoint = edge.getCloudEndpoint();
        this.rootRuleChainId = edge.getRootRuleChainId();
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.EDGE;
    }

    @Override
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        RuleChainId this$rootRuleChainId = this.getRootRuleChainId();
        RuleChainId other$rootRuleChainId = other.getRootRuleChainId();
        if (this$rootRuleChainId == null ? other$rootRuleChainId != null : !((Object)this$rootRuleChainId).equals(other$rootRuleChainId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$edgeLicenseKey = this.getEdgeLicenseKey();
        String other$edgeLicenseKey = other.getEdgeLicenseKey();
        if (this$edgeLicenseKey == null ? other$edgeLicenseKey != null : !this$edgeLicenseKey.equals(other$edgeLicenseKey)) {
            return false;
        }
        String this$cloudEndpoint = this.getCloudEndpoint();
        String other$cloudEndpoint = other.getCloudEndpoint();
        return !(this$cloudEndpoint == null ? other$cloudEndpoint != null : !this$cloudEndpoint.equals(other$cloudEndpoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Edge;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        RuleChainId $rootRuleChainId = this.getRootRuleChainId();
        result = result * 59 + ($rootRuleChainId == null ? 43 : ((Object)$rootRuleChainId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $edgeLicenseKey = this.getEdgeLicenseKey();
        result = result * 59 + ($edgeLicenseKey == null ? 43 : $edgeLicenseKey.hashCode());
        String $cloudEndpoint = this.getCloudEndpoint();
        result = result * 59 + ($cloudEndpoint == null ? 43 : $cloudEndpoint.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Edge(tenantId=" + this.getTenantId() + ", customerId=" + this.getCustomerId() + ", rootRuleChainId=" + this.getRootRuleChainId() + ", name=" + this.getName() + ", type=" + this.getType() + ", label=" + this.getLabel() + ", routingKey=" + this.getRoutingKey() + ", secret=" + this.getSecret() + ", edgeLicenseKey=" + this.getEdgeLicenseKey() + ", cloudEndpoint=" + this.getCloudEndpoint() + ")";
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    public RuleChainId getRootRuleChainId() {
        return this.rootRuleChainId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getEdgeLicenseKey() {
        return this.edgeLicenseKey;
    }

    public String getCloudEndpoint() {
        return this.cloudEndpoint;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    public void setRootRuleChainId(RuleChainId rootRuleChainId) {
        this.rootRuleChainId = rootRuleChainId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setEdgeLicenseKey(String edgeLicenseKey) {
        this.edgeLicenseKey = edgeLicenseKey;
    }

    public void setCloudEndpoint(String cloudEndpoint) {
        this.cloudEndpoint = cloudEndpoint;
    }
}

