/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.NoXss;

public class TbResourceInfo
extends SearchTextBased<TbResourceId>
implements HasName,
TenantEntity {
    private static final Logger log = LoggerFactory.getLogger(TbResourceInfo.class);
    private static final long serialVersionUID = 7282664529021651736L;
    private TenantId tenantId;
    @NoXss
    private String title;
    private ResourceType resourceType;
    private String resourceKey;
    private String searchText;

    public TbResourceInfo() {
    }

    public TbResourceInfo(TbResourceId id) {
        super(id);
    }

    public TbResourceInfo(TbResourceInfo resourceInfo) {
        super(resourceInfo);
        this.tenantId = resourceInfo.getTenantId();
        this.title = resourceInfo.getTitle();
        this.resourceType = resourceInfo.getResourceType();
        this.resourceKey = resourceInfo.getResourceKey();
        this.searchText = resourceInfo.getSearchText();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.title;
    }

    @Override
    public String getSearchText() {
        return this.searchText != null ? this.searchText : this.title;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceInfo [tenantId=");
        builder.append(this.tenantId);
        builder.append(", id=");
        builder.append(this.getUuidId());
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", title=");
        builder.append(this.title);
        builder.append(", resourceType=");
        builder.append((Object)this.resourceType);
        builder.append(", resourceKey=");
        builder.append(this.resourceKey);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.TB_RESOURCE;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getTitle() {
        return this.title;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbResourceInfo)) {
            return false;
        }
        TbResourceInfo other = (TbResourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        ResourceType this$resourceType = this.getResourceType();
        ResourceType other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType)) {
            return false;
        }
        String this$resourceKey = this.getResourceKey();
        String other$resourceKey = other.getResourceKey();
        if (this$resourceKey == null ? other$resourceKey != null : !this$resourceKey.equals(other$resourceKey)) {
            return false;
        }
        String this$searchText = this.getSearchText();
        String other$searchText = other.getSearchText();
        return !(this$searchText == null ? other$searchText != null : !this$searchText.equals(other$searchText));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbResourceInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        ResourceType $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)((Object)$resourceType)).hashCode());
        String $resourceKey = this.getResourceKey();
        result = result * 59 + ($resourceKey == null ? 43 : $resourceKey.hashCode());
        String $searchText = this.getSearchText();
        result = result * 59 + ($searchText == null ? 43 : $searchText.hashCode());
        return result;
    }
}

