/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;

public final class DeviceProfileInfo
extends EntityInfo {
    private final String image;
    private final DashboardId defaultDashboardId;
    private final DeviceProfileType type;
    private final DeviceTransportType transportType;

    @JsonCreator
    public DeviceProfileInfo(@JsonProperty(value="id") EntityId id, @JsonProperty(value="name") String name, @JsonProperty(value="image") String image, @JsonProperty(value="defaultDashboardId") DashboardId defaultDashboardId, @JsonProperty(value="type") DeviceProfileType type, @JsonProperty(value="transportType") DeviceTransportType transportType) {
        super(id, name);
        this.image = image;
        this.defaultDashboardId = defaultDashboardId;
        this.type = type;
        this.transportType = transportType;
    }

    public DeviceProfileInfo(UUID uuid, String name, String image, UUID defaultDashboardId, DeviceProfileType type, DeviceTransportType transportType) {
        super(EntityIdFactory.getByTypeAndUuid(EntityType.DEVICE_PROFILE, uuid), name);
        this.image = image;
        this.defaultDashboardId = defaultDashboardId != null ? new DashboardId(defaultDashboardId) : null;
        this.type = type;
        this.transportType = transportType;
    }

    public String getImage() {
        return this.image;
    }

    public DashboardId getDefaultDashboardId() {
        return this.defaultDashboardId;
    }

    public DeviceProfileType getType() {
        return this.type;
    }

    public DeviceTransportType getTransportType() {
        return this.transportType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceProfileInfo)) {
            return false;
        }
        DeviceProfileInfo other = (DeviceProfileInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        DashboardId this$defaultDashboardId = this.getDefaultDashboardId();
        DashboardId other$defaultDashboardId = other.getDefaultDashboardId();
        if (this$defaultDashboardId == null ? other$defaultDashboardId != null : !((Object)this$defaultDashboardId).equals(other$defaultDashboardId)) {
            return false;
        }
        DeviceProfileType this$type = this.getType();
        DeviceProfileType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DeviceTransportType this$transportType = this.getTransportType();
        DeviceTransportType other$transportType = other.getTransportType();
        return !(this$transportType == null ? other$transportType != null : !((Object)((Object)this$transportType)).equals((Object)other$transportType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeviceProfileInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        DashboardId $defaultDashboardId = this.getDefaultDashboardId();
        result = result * 59 + ($defaultDashboardId == null ? 43 : ((Object)$defaultDashboardId).hashCode());
        DeviceProfileType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DeviceTransportType $transportType = this.getTransportType();
        result = result * 59 + ($transportType == null ? 43 : ((Object)((Object)$transportType)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DeviceProfileInfo(super=" + super.toString() + ", image=" + this.getImage() + ", defaultDashboardId=" + this.getDefaultDashboardId() + ", type=" + this.getType() + ", transportType=" + this.getTransportType() + ")";
    }
}

