/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.DeviceProfileProvisionType;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOtaPackage;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.device.profile.DeviceProfileData;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.NoXss;

public class DeviceProfile
extends SearchTextBased<DeviceProfileId>
implements HasName,
TenantEntity,
HasOtaPackage {
    private static final Logger log = LoggerFactory.getLogger(DeviceProfile.class);
    private TenantId tenantId;
    @NoXss
    private String name;
    @NoXss
    private String description;
    private String image;
    private boolean isDefault;
    private DeviceProfileType type;
    private DeviceTransportType transportType;
    private DeviceProfileProvisionType provisionType;
    private RuleChainId defaultRuleChainId;
    private DashboardId defaultDashboardId;
    @NoXss
    private String defaultQueueName;
    @Valid
    private transient DeviceProfileData profileData;
    @JsonIgnore
    private byte[] profileDataBytes;
    @NoXss
    private String provisionDeviceKey;
    private OtaPackageId firmwareId;
    private OtaPackageId softwareId;

    public DeviceProfile() {
    }

    public DeviceProfile(DeviceProfileId deviceProfileId) {
        super(deviceProfileId);
    }

    public DeviceProfile(DeviceProfile deviceProfile) {
        super(deviceProfile);
        this.tenantId = deviceProfile.getTenantId();
        this.name = deviceProfile.getName();
        this.description = deviceProfile.getDescription();
        this.image = deviceProfile.getImage();
        this.isDefault = deviceProfile.isDefault();
        this.defaultRuleChainId = deviceProfile.getDefaultRuleChainId();
        this.defaultDashboardId = deviceProfile.getDefaultDashboardId();
        this.defaultQueueName = deviceProfile.getDefaultQueueName();
        this.setProfileData(deviceProfile.getProfileData());
        this.provisionDeviceKey = deviceProfile.getProvisionDeviceKey();
        this.firmwareId = deviceProfile.getFirmwareId();
        this.softwareId = deviceProfile.getSoftwareId();
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DeviceProfileData getProfileData() {
        if (this.profileData != null) {
            return this.profileData;
        }
        if (this.profileDataBytes != null) {
            try {
                this.profileData = (DeviceProfileData)SearchTextBasedWithAdditionalInfo.mapper.readValue((InputStream)new ByteArrayInputStream(this.profileDataBytes), DeviceProfileData.class);
            }
            catch (IOException e) {
                log.warn("Can't deserialize device profile data: ", (Throwable)e);
                return null;
            }
            return this.profileData;
        }
        return null;
    }

    public void setProfileData(DeviceProfileData data) {
        this.profileData = data;
        try {
            this.profileDataBytes = data != null ? SearchTextBasedWithAdditionalInfo.mapper.writeValueAsBytes((Object)data) : null;
        }
        catch (JsonProcessingException e) {
            log.warn("Can't serialize device profile data: ", (Throwable)e);
        }
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.DEVICE_PROFILE;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImage() {
        return this.image;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public DeviceProfileType getType() {
        return this.type;
    }

    public DeviceTransportType getTransportType() {
        return this.transportType;
    }

    public DeviceProfileProvisionType getProvisionType() {
        return this.provisionType;
    }

    public RuleChainId getDefaultRuleChainId() {
        return this.defaultRuleChainId;
    }

    public DashboardId getDefaultDashboardId() {
        return this.defaultDashboardId;
    }

    public String getDefaultQueueName() {
        return this.defaultQueueName;
    }

    public byte[] getProfileDataBytes() {
        return this.profileDataBytes;
    }

    public String getProvisionDeviceKey() {
        return this.provisionDeviceKey;
    }

    @Override
    public OtaPackageId getFirmwareId() {
        return this.firmwareId;
    }

    @Override
    public OtaPackageId getSoftwareId() {
        return this.softwareId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setType(DeviceProfileType type) {
        this.type = type;
    }

    public void setTransportType(DeviceTransportType transportType) {
        this.transportType = transportType;
    }

    public void setProvisionType(DeviceProfileProvisionType provisionType) {
        this.provisionType = provisionType;
    }

    public void setDefaultRuleChainId(RuleChainId defaultRuleChainId) {
        this.defaultRuleChainId = defaultRuleChainId;
    }

    public void setDefaultDashboardId(DashboardId defaultDashboardId) {
        this.defaultDashboardId = defaultDashboardId;
    }

    public void setDefaultQueueName(String defaultQueueName) {
        this.defaultQueueName = defaultQueueName;
    }

    @JsonIgnore
    public void setProfileDataBytes(byte[] profileDataBytes) {
        this.profileDataBytes = profileDataBytes;
    }

    public void setProvisionDeviceKey(String provisionDeviceKey) {
        this.provisionDeviceKey = provisionDeviceKey;
    }

    public void setFirmwareId(OtaPackageId firmwareId) {
        this.firmwareId = firmwareId;
    }

    public void setSoftwareId(OtaPackageId softwareId) {
        this.softwareId = softwareId;
    }

    @Override
    public String toString() {
        return "DeviceProfile(tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", image=" + this.getImage() + ", isDefault=" + this.isDefault() + ", type=" + this.getType() + ", transportType=" + this.getTransportType() + ", provisionType=" + this.getProvisionType() + ", defaultRuleChainId=" + this.getDefaultRuleChainId() + ", defaultDashboardId=" + this.getDefaultDashboardId() + ", defaultQueueName=" + this.getDefaultQueueName() + ", profileData=" + this.getProfileData() + ", profileDataBytes=" + Arrays.toString(this.getProfileDataBytes()) + ", provisionDeviceKey=" + this.getProvisionDeviceKey() + ", firmwareId=" + this.getFirmwareId() + ", softwareId=" + this.getSoftwareId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceProfile)) {
            return false;
        }
        DeviceProfile other = (DeviceProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        DeviceProfileType this$type = this.getType();
        DeviceProfileType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DeviceTransportType this$transportType = this.getTransportType();
        DeviceTransportType other$transportType = other.getTransportType();
        if (this$transportType == null ? other$transportType != null : !((Object)((Object)this$transportType)).equals((Object)other$transportType)) {
            return false;
        }
        DeviceProfileProvisionType this$provisionType = this.getProvisionType();
        DeviceProfileProvisionType other$provisionType = other.getProvisionType();
        if (this$provisionType == null ? other$provisionType != null : !((Object)((Object)this$provisionType)).equals((Object)other$provisionType)) {
            return false;
        }
        RuleChainId this$defaultRuleChainId = this.getDefaultRuleChainId();
        RuleChainId other$defaultRuleChainId = other.getDefaultRuleChainId();
        if (this$defaultRuleChainId == null ? other$defaultRuleChainId != null : !((Object)this$defaultRuleChainId).equals(other$defaultRuleChainId)) {
            return false;
        }
        DashboardId this$defaultDashboardId = this.getDefaultDashboardId();
        DashboardId other$defaultDashboardId = other.getDefaultDashboardId();
        if (this$defaultDashboardId == null ? other$defaultDashboardId != null : !((Object)this$defaultDashboardId).equals(other$defaultDashboardId)) {
            return false;
        }
        String this$defaultQueueName = this.getDefaultQueueName();
        String other$defaultQueueName = other.getDefaultQueueName();
        if (this$defaultQueueName == null ? other$defaultQueueName != null : !this$defaultQueueName.equals(other$defaultQueueName)) {
            return false;
        }
        if (!Arrays.equals(this.getProfileDataBytes(), other.getProfileDataBytes())) {
            return false;
        }
        String this$provisionDeviceKey = this.getProvisionDeviceKey();
        String other$provisionDeviceKey = other.getProvisionDeviceKey();
        if (this$provisionDeviceKey == null ? other$provisionDeviceKey != null : !this$provisionDeviceKey.equals(other$provisionDeviceKey)) {
            return false;
        }
        OtaPackageId this$firmwareId = this.getFirmwareId();
        OtaPackageId other$firmwareId = other.getFirmwareId();
        if (this$firmwareId == null ? other$firmwareId != null : !((Object)this$firmwareId).equals(other$firmwareId)) {
            return false;
        }
        OtaPackageId this$softwareId = this.getSoftwareId();
        OtaPackageId other$softwareId = other.getSoftwareId();
        return !(this$softwareId == null ? other$softwareId != null : !((Object)this$softwareId).equals(other$softwareId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceProfile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDefault() ? 79 : 97);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        DeviceProfileType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DeviceTransportType $transportType = this.getTransportType();
        result = result * 59 + ($transportType == null ? 43 : ((Object)((Object)$transportType)).hashCode());
        DeviceProfileProvisionType $provisionType = this.getProvisionType();
        result = result * 59 + ($provisionType == null ? 43 : ((Object)((Object)$provisionType)).hashCode());
        RuleChainId $defaultRuleChainId = this.getDefaultRuleChainId();
        result = result * 59 + ($defaultRuleChainId == null ? 43 : ((Object)$defaultRuleChainId).hashCode());
        DashboardId $defaultDashboardId = this.getDefaultDashboardId();
        result = result * 59 + ($defaultDashboardId == null ? 43 : ((Object)$defaultDashboardId).hashCode());
        String $defaultQueueName = this.getDefaultQueueName();
        result = result * 59 + ($defaultQueueName == null ? 43 : $defaultQueueName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getProfileDataBytes());
        String $provisionDeviceKey = this.getProvisionDeviceKey();
        result = result * 59 + ($provisionDeviceKey == null ? 43 : $provisionDeviceKey.hashCode());
        OtaPackageId $firmwareId = this.getFirmwareId();
        result = result * 59 + ($firmwareId == null ? 43 : ((Object)$firmwareId).hashCode());
        OtaPackageId $softwareId = this.getSoftwareId();
        result = result * 59 + ($softwareId == null ? 43 : ((Object)$softwareId).hashCode());
        return result;
    }
}

