/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.wl;

import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.wl.Favicon;
import org.thingsboard.server.common.data.wl.PaletteSettings;

public class WhiteLabelingParams {
    protected String logoImageUrl;
    protected String logoImageChecksum;
    protected Integer logoImageHeight;
    protected String appTitle;
    protected Favicon favicon;
    protected String faviconChecksum;
    protected PaletteSettings paletteSettings;
    protected String helpLinkBaseUrl;
    protected Boolean enableHelpLinks;
    protected boolean whiteLabelingEnabled = true;
    protected Boolean showNameVersion;
    protected String platformName;
    protected String platformVersion;

    public WhiteLabelingParams merge(WhiteLabelingParams otherWlParams) {
        if (StringUtils.isEmpty((CharSequence)this.logoImageUrl)) {
            this.logoImageUrl = otherWlParams.logoImageUrl;
            this.logoImageChecksum = otherWlParams.logoImageChecksum;
        }
        if (this.logoImageHeight == null) {
            this.logoImageHeight = otherWlParams.logoImageHeight;
        }
        if (StringUtils.isEmpty((CharSequence)this.appTitle)) {
            this.appTitle = otherWlParams.appTitle;
        }
        if (this.favicon == null || StringUtils.isEmpty((CharSequence)this.favicon.getUrl())) {
            this.favicon = otherWlParams.favicon;
            this.faviconChecksum = otherWlParams.faviconChecksum;
        }
        if (this.paletteSettings == null) {
            this.paletteSettings = otherWlParams.paletteSettings;
        } else if (otherWlParams.paletteSettings != null) {
            this.paletteSettings.merge(otherWlParams.paletteSettings);
        }
        if (otherWlParams.helpLinkBaseUrl != null) {
            this.helpLinkBaseUrl = otherWlParams.helpLinkBaseUrl;
        }
        if (otherWlParams.enableHelpLinks != null) {
            this.enableHelpLinks = otherWlParams.enableHelpLinks;
        }
        if (this.showNameVersion == null) {
            this.showNameVersion = otherWlParams.showNameVersion;
            this.platformName = otherWlParams.platformName;
            this.platformVersion = otherWlParams.platformVersion;
        }
        return this;
    }

    public void prepareImages(String logoImageChecksum, String faviconChecksum) {
        if (!StringUtils.isEmpty((CharSequence)logoImageChecksum) && logoImageChecksum.equals(this.logoImageChecksum)) {
            this.logoImageUrl = null;
        }
        if (!StringUtils.isEmpty((CharSequence)faviconChecksum) && faviconChecksum.equals(this.faviconChecksum)) {
            this.favicon = null;
        }
    }

    public String getLogoImageUrl() {
        return this.logoImageUrl;
    }

    public String getLogoImageChecksum() {
        return this.logoImageChecksum;
    }

    public Integer getLogoImageHeight() {
        return this.logoImageHeight;
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public Favicon getFavicon() {
        return this.favicon;
    }

    public String getFaviconChecksum() {
        return this.faviconChecksum;
    }

    public PaletteSettings getPaletteSettings() {
        return this.paletteSettings;
    }

    public String getHelpLinkBaseUrl() {
        return this.helpLinkBaseUrl;
    }

    public Boolean getEnableHelpLinks() {
        return this.enableHelpLinks;
    }

    public boolean isWhiteLabelingEnabled() {
        return this.whiteLabelingEnabled;
    }

    public Boolean getShowNameVersion() {
        return this.showNameVersion;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setLogoImageUrl(String logoImageUrl) {
        this.logoImageUrl = logoImageUrl;
    }

    public void setLogoImageChecksum(String logoImageChecksum) {
        this.logoImageChecksum = logoImageChecksum;
    }

    public void setLogoImageHeight(Integer logoImageHeight) {
        this.logoImageHeight = logoImageHeight;
    }

    public void setAppTitle(String appTitle) {
        this.appTitle = appTitle;
    }

    public void setFavicon(Favicon favicon) {
        this.favicon = favicon;
    }

    public void setFaviconChecksum(String faviconChecksum) {
        this.faviconChecksum = faviconChecksum;
    }

    public void setPaletteSettings(PaletteSettings paletteSettings) {
        this.paletteSettings = paletteSettings;
    }

    public void setHelpLinkBaseUrl(String helpLinkBaseUrl) {
        this.helpLinkBaseUrl = helpLinkBaseUrl;
    }

    public void setEnableHelpLinks(Boolean enableHelpLinks) {
        this.enableHelpLinks = enableHelpLinks;
    }

    public void setWhiteLabelingEnabled(boolean whiteLabelingEnabled) {
        this.whiteLabelingEnabled = whiteLabelingEnabled;
    }

    public void setShowNameVersion(Boolean showNameVersion) {
        this.showNameVersion = showNameVersion;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String toString() {
        return "WhiteLabelingParams(logoImageUrl=" + this.getLogoImageUrl() + ", logoImageChecksum=" + this.getLogoImageChecksum() + ", logoImageHeight=" + this.getLogoImageHeight() + ", appTitle=" + this.getAppTitle() + ", favicon=" + this.getFavicon() + ", faviconChecksum=" + this.getFaviconChecksum() + ", paletteSettings=" + this.getPaletteSettings() + ", helpLinkBaseUrl=" + this.getHelpLinkBaseUrl() + ", enableHelpLinks=" + this.getEnableHelpLinks() + ", whiteLabelingEnabled=" + this.isWhiteLabelingEnabled() + ", showNameVersion=" + this.getShowNameVersion() + ", platformName=" + this.getPlatformName() + ", platformVersion=" + this.getPlatformVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhiteLabelingParams)) {
            return false;
        }
        WhiteLabelingParams other = (WhiteLabelingParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$logoImageUrl = this.getLogoImageUrl();
        String other$logoImageUrl = other.getLogoImageUrl();
        if (this$logoImageUrl == null ? other$logoImageUrl != null : !this$logoImageUrl.equals(other$logoImageUrl)) {
            return false;
        }
        String this$logoImageChecksum = this.getLogoImageChecksum();
        String other$logoImageChecksum = other.getLogoImageChecksum();
        if (this$logoImageChecksum == null ? other$logoImageChecksum != null : !this$logoImageChecksum.equals(other$logoImageChecksum)) {
            return false;
        }
        Integer this$logoImageHeight = this.getLogoImageHeight();
        Integer other$logoImageHeight = other.getLogoImageHeight();
        if (this$logoImageHeight == null ? other$logoImageHeight != null : !((Object)this$logoImageHeight).equals(other$logoImageHeight)) {
            return false;
        }
        String this$appTitle = this.getAppTitle();
        String other$appTitle = other.getAppTitle();
        if (this$appTitle == null ? other$appTitle != null : !this$appTitle.equals(other$appTitle)) {
            return false;
        }
        Favicon this$favicon = this.getFavicon();
        Favicon other$favicon = other.getFavicon();
        if (this$favicon == null ? other$favicon != null : !((Object)this$favicon).equals(other$favicon)) {
            return false;
        }
        String this$faviconChecksum = this.getFaviconChecksum();
        String other$faviconChecksum = other.getFaviconChecksum();
        if (this$faviconChecksum == null ? other$faviconChecksum != null : !this$faviconChecksum.equals(other$faviconChecksum)) {
            return false;
        }
        PaletteSettings this$paletteSettings = this.getPaletteSettings();
        PaletteSettings other$paletteSettings = other.getPaletteSettings();
        if (this$paletteSettings == null ? other$paletteSettings != null : !((Object)this$paletteSettings).equals(other$paletteSettings)) {
            return false;
        }
        String this$helpLinkBaseUrl = this.getHelpLinkBaseUrl();
        String other$helpLinkBaseUrl = other.getHelpLinkBaseUrl();
        if (this$helpLinkBaseUrl == null ? other$helpLinkBaseUrl != null : !this$helpLinkBaseUrl.equals(other$helpLinkBaseUrl)) {
            return false;
        }
        Boolean this$enableHelpLinks = this.getEnableHelpLinks();
        Boolean other$enableHelpLinks = other.getEnableHelpLinks();
        if (this$enableHelpLinks == null ? other$enableHelpLinks != null : !((Object)this$enableHelpLinks).equals(other$enableHelpLinks)) {
            return false;
        }
        if (this.isWhiteLabelingEnabled() != other.isWhiteLabelingEnabled()) {
            return false;
        }
        Boolean this$showNameVersion = this.getShowNameVersion();
        Boolean other$showNameVersion = other.getShowNameVersion();
        if (this$showNameVersion == null ? other$showNameVersion != null : !((Object)this$showNameVersion).equals(other$showNameVersion)) {
            return false;
        }
        String this$platformName = this.getPlatformName();
        String other$platformName = other.getPlatformName();
        if (this$platformName == null ? other$platformName != null : !this$platformName.equals(other$platformName)) {
            return false;
        }
        String this$platformVersion = this.getPlatformVersion();
        String other$platformVersion = other.getPlatformVersion();
        return !(this$platformVersion == null ? other$platformVersion != null : !this$platformVersion.equals(other$platformVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhiteLabelingParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $logoImageUrl = this.getLogoImageUrl();
        result = result * 59 + ($logoImageUrl == null ? 43 : $logoImageUrl.hashCode());
        String $logoImageChecksum = this.getLogoImageChecksum();
        result = result * 59 + ($logoImageChecksum == null ? 43 : $logoImageChecksum.hashCode());
        Integer $logoImageHeight = this.getLogoImageHeight();
        result = result * 59 + ($logoImageHeight == null ? 43 : ((Object)$logoImageHeight).hashCode());
        String $appTitle = this.getAppTitle();
        result = result * 59 + ($appTitle == null ? 43 : $appTitle.hashCode());
        Favicon $favicon = this.getFavicon();
        result = result * 59 + ($favicon == null ? 43 : ((Object)$favicon).hashCode());
        String $faviconChecksum = this.getFaviconChecksum();
        result = result * 59 + ($faviconChecksum == null ? 43 : $faviconChecksum.hashCode());
        PaletteSettings $paletteSettings = this.getPaletteSettings();
        result = result * 59 + ($paletteSettings == null ? 43 : ((Object)$paletteSettings).hashCode());
        String $helpLinkBaseUrl = this.getHelpLinkBaseUrl();
        result = result * 59 + ($helpLinkBaseUrl == null ? 43 : $helpLinkBaseUrl.hashCode());
        Boolean $enableHelpLinks = this.getEnableHelpLinks();
        result = result * 59 + ($enableHelpLinks == null ? 43 : ((Object)$enableHelpLinks).hashCode());
        result = result * 59 + (this.isWhiteLabelingEnabled() ? 79 : 97);
        Boolean $showNameVersion = this.getShowNameVersion();
        result = result * 59 + ($showNameVersion == null ? 43 : ((Object)$showNameVersion).hashCode());
        String $platformName = this.getPlatformName();
        result = result * 59 + ($platformName == null ? 43 : $platformName.hashCode());
        String $platformVersion = this.getPlatformVersion();
        result = result * 59 + ($platformVersion == null ? 43 : $platformVersion.hashCode());
        return result;
    }
}

