/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.SearchTextBased;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;

public class WidgetsBundle
extends SearchTextBased<WidgetsBundleId>
implements TenantEntity {
    private static final long serialVersionUID = -7627368878362410489L;
    private TenantId tenantId;
    private String alias;
    private String title;
    private byte[] image;

    public WidgetsBundle() {
    }

    public WidgetsBundle(WidgetsBundleId id) {
        super(id);
    }

    public WidgetsBundle(WidgetsBundle widgetsBundle) {
        super(widgetsBundle);
        this.tenantId = widgetsBundle.getTenantId();
        this.alias = widgetsBundle.getAlias();
        this.title = widgetsBundle.getTitle();
        this.image = widgetsBundle.getImage();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    @Override
    public String getSearchText() {
        return this.getTitle();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.image);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WidgetsBundle that = (WidgetsBundle)o;
        if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
            return false;
        }
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return Arrays.equals(this.image, that.image);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WidgetsBundle{");
        sb.append("tenantId=").append(this.tenantId);
        sb.append(", alias='").append(this.alias).append('\'');
        sb.append(", title='").append(this.title).append('\'');
        sb.append(", image=").append(Arrays.toString(this.image));
        sb.append('}');
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.WIDGETS_BUNDLE;
    }
}

