/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;

public class RuleNode
extends SearchTextBasedWithAdditionalInfo<RuleNodeId>
implements HasName {
    private static final Logger log = LoggerFactory.getLogger(RuleNode.class);
    private static final long serialVersionUID = -5656679015121235465L;
    private RuleChainId ruleChainId;
    private String type;
    private String name;
    private boolean debugMode;
    private transient JsonNode configuration;
    @JsonIgnore
    private byte[] configurationBytes;

    public RuleNode() {
    }

    public RuleNode(RuleNodeId id) {
        super(id);
    }

    public RuleNode(RuleNode ruleNode) {
        super(ruleNode);
        this.ruleChainId = ruleNode.getRuleChainId();
        this.type = ruleNode.getType();
        this.name = ruleNode.getName();
        this.debugMode = ruleNode.isDebugMode();
        this.setConfiguration(ruleNode.getConfiguration());
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JsonNode getConfiguration() {
        return SearchTextBasedWithAdditionalInfo.getJson(() -> this.configuration, () -> this.configurationBytes);
    }

    public void setConfiguration(JsonNode data) {
        RuleNode.setJson(data, json -> {
            this.configuration = json;
        }, bytes -> {
            this.configurationBytes = bytes;
        });
    }

    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    public String getType() {
        return this.type;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public byte[] getConfigurationBytes() {
        return this.configurationBytes;
    }

    public void setRuleChainId(RuleChainId ruleChainId) {
        this.ruleChainId = ruleChainId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setConfigurationBytes(byte[] configurationBytes) {
        this.configurationBytes = configurationBytes;
    }

    @Override
    public String toString() {
        return "RuleNode(ruleChainId=" + this.getRuleChainId() + ", type=" + this.getType() + ", name=" + this.getName() + ", debugMode=" + this.isDebugMode() + ", configuration=" + this.getConfiguration() + ", configurationBytes=" + Arrays.toString(this.getConfigurationBytes()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleNode)) {
            return false;
        }
        RuleNode other = (RuleNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !((Object)this$ruleChainId).equals(other$ruleChainId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        return Arrays.equals(this.getConfigurationBytes(), other.getConfigurationBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : ((Object)$ruleChainId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getConfigurationBytes());
        return result;
    }
}

