/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;

public class RuleChain
extends SearchTextBasedWithAdditionalInfo<RuleChainId>
implements HasName,
TenantEntity {
    private static final Logger log = LoggerFactory.getLogger(RuleChain.class);
    private static final long serialVersionUID = -5656679015121935465L;
    private TenantId tenantId;
    private String name;
    private RuleNodeId firstRuleNodeId;
    private boolean root;
    private boolean debugMode;
    private transient JsonNode configuration;
    @JsonIgnore
    private byte[] configurationBytes;

    public RuleChain() {
    }

    public RuleChain(RuleChainId id) {
        super(id);
    }

    public RuleChain(RuleChain ruleChain) {
        super(ruleChain);
        this.tenantId = ruleChain.getTenantId();
        this.name = ruleChain.getName();
        this.firstRuleNodeId = ruleChain.getFirstRuleNodeId();
        this.root = ruleChain.isRoot();
        this.setConfiguration(ruleChain.getConfiguration());
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JsonNode getConfiguration() {
        return SearchTextBasedWithAdditionalInfo.getJson(() -> this.configuration, () -> this.configurationBytes);
    }

    public void setConfiguration(JsonNode data) {
        RuleChain.setJson(data, json -> {
            this.configuration = json;
        }, bytes -> {
            this.configurationBytes = bytes;
        });
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.RULE_CHAIN;
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    public RuleNodeId getFirstRuleNodeId() {
        return this.firstRuleNodeId;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public byte[] getConfigurationBytes() {
        return this.configurationBytes;
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFirstRuleNodeId(RuleNodeId firstRuleNodeId) {
        this.firstRuleNodeId = firstRuleNodeId;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setConfigurationBytes(byte[] configurationBytes) {
        this.configurationBytes = configurationBytes;
    }

    @Override
    public String toString() {
        return "RuleChain(tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", firstRuleNodeId=" + this.getFirstRuleNodeId() + ", root=" + this.isRoot() + ", debugMode=" + this.isDebugMode() + ", configuration=" + this.getConfiguration() + ", configurationBytes=" + Arrays.toString(this.getConfigurationBytes()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleChain)) {
            return false;
        }
        RuleChain other = (RuleChain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        RuleNodeId this$firstRuleNodeId = this.getFirstRuleNodeId();
        RuleNodeId other$firstRuleNodeId = other.getFirstRuleNodeId();
        if (this$firstRuleNodeId == null ? other$firstRuleNodeId != null : !((Object)this$firstRuleNodeId).equals(other$firstRuleNodeId)) {
            return false;
        }
        if (this.isRoot() != other.isRoot()) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        return Arrays.equals(this.getConfigurationBytes(), other.getConfigurationBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleChain;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        RuleNodeId $firstRuleNodeId = this.getFirstRuleNodeId();
        result = result * 59 + ($firstRuleNodeId == null ? 43 : ((Object)$firstRuleNodeId).hashCode());
        result = result * 59 + (this.isRoot() ? 79 : 97);
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getConfigurationBytes());
        return result;
    }
}

