/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.permission.MergedGroupPermissionInfo;
import org.thingsboard.server.common.data.permission.MergedGroupTypePermissionInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;

public final class MergedUserPermissions {
    private final Map<Resource, Set<Operation>> genericPermissions;
    private final Map<EntityGroupId, MergedGroupPermissionInfo> groupPermissions;
    private final Map<EntityType, MergedGroupTypePermissionInfo> readGroupPermissions;

    public MergedUserPermissions(Map<Resource, Set<Operation>> genericPermissions, Map<EntityGroupId, MergedGroupPermissionInfo> groupPermissions) {
        this.genericPermissions = genericPermissions;
        this.groupPermissions = groupPermissions;
        this.readGroupPermissions = new HashMap<EntityType, MergedGroupTypePermissionInfo>();
        for (EntityType groupType : EntityGroup.groupTypes) {
            Resource resource = Resource.groupResourceFromGroupType(groupType);
            boolean hasGenericRead = this.hasGenericPermission(resource, Operation.READ);
            MergedGroupTypePermissionInfo groupTypePermissionInfo = new MergedGroupTypePermissionInfo(new ArrayList<EntityGroupId>(), hasGenericRead);
            this.readGroupPermissions.put(groupType, groupTypePermissionInfo);
        }
        this.groupPermissions.forEach((id, info) -> {
            if (this.checkOperation(info.getOperations(), Operation.READ)) {
                this.readGroupPermissions.get((Object)info.getEntityType()).getEntityGroupIds().add((EntityGroupId)id);
            }
        });
    }

    public boolean hasGenericPermission(Resource resource, Operation operation) {
        return this.hasGenericResourcePermission(resource, operation) || this.hasGenericAllPermission(operation);
    }

    private boolean hasGenericAllPermission(Operation operation) {
        Set<Operation> operations = this.genericPermissions.get((Object)Resource.ALL);
        return operations != null && this.checkOperation(operations, operation);
    }

    private boolean hasGenericResourcePermission(Resource resource, Operation operation) {
        Set<Operation> operations = this.genericPermissions.get((Object)resource);
        return operations != null && this.checkOperation(operations, operation);
    }

    private boolean checkOperation(Set<Operation> operations, Operation operation) {
        return operations.contains((Object)Operation.ALL) || operations.contains((Object)operation);
    }

    public boolean hasGroupPermissions(EntityGroupId entityGroupId, Operation operation) {
        MergedGroupPermissionInfo permissionInfo = this.groupPermissions.get(entityGroupId);
        return permissionInfo != null && this.checkOperation(permissionInfo.getOperations(), operation);
    }

    public Map<Resource, Set<Operation>> getGenericPermissions() {
        return this.genericPermissions;
    }

    public Map<EntityGroupId, MergedGroupPermissionInfo> getGroupPermissions() {
        return this.groupPermissions;
    }

    public Map<EntityType, MergedGroupTypePermissionInfo> getReadGroupPermissions() {
        return this.readGroupPermissions;
    }
}

